(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    203992,       3928]
NotebookOptionsPosition[    198351,       3744]
NotebookOutlinePosition[    201299,       3840]
CellTagsIndexPosition[    201207,       3834]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["The Season Package (by Ekkehart Schlicht)", "Title",
 CellTags->"b:0"],

Cell[TextData[{
 "Revision 3 of February 2017. Adapted to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 8.\n "
}], "Text",
 CellFrame->{{0, 0}, {0.5, 0}},
 CellChangeTimes->{{3.695534808463867*^9, 3.695534849557617*^9}, {
  3.6957340498085938`*^9, 3.6957340786992188`*^9}},
 CellTags->"b:0"],

Cell[TextData[{
 "\nThe package implements Schlicht's (1984) seasonal adjustment method. It \
decomposes a time series ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "t"], ",", " ", 
    RowBox[{"t", " ", "\[Element]", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "...", ",", "T"}], "}"}], " "}]}], TraditionalForm]]],
 "into a trend ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["y", "t"], ",", " ", 
    RowBox[{"t", " ", "\[Element]", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "...", ",", "T"}], "}"}], " "}]}], TraditionalForm]]],
 ", a seasonal component ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "t"], ",", " ", 
    RowBox[{"t", " ", "\[Element]", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "...", ",", "T"}], "}"}], " "}]}], TraditionalForm]]],
 ", and an irregular component ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["u", "t"], ",", " ", 
    RowBox[{"t", " ", "\[Element]", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "...", ",", "T"}], "}"}], " "}]}], TraditionalForm]]],
 "such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "t"], "=", 
    RowBox[{
     SubscriptBox["y", "t"], "+", 
     SubscriptBox["z", "t"], "+", 
     RowBox[{
      SubscriptBox["u", "t"], " ", "for", " ", "all", "  ", 
      RowBox[{"t", ".", " "}]}]}]}], TraditionalForm]]],
 "The method uses non-parametric splines. It combines the trend filter \
proposed by Leser (1961),  known as the HP-Filter filter, the seasonal filter \
proposed by Schlicht and Pauly (1983) and the orthogonal parametrization \
proposed by Schlicht (1984, 2005). For the treatment of missing observations \
and structural breaks, see Schlicht(2009). In contrast to prevailing methods, \
the method used here is based on an explicit statistical model (state-space). \
\nSeason is appropriate for smoothing time series with higher than annual \
frequency.  Season is inappropriate for smoothing annual data or \
deseasonalized time series; for this, use the HPFilter package by Johannes \
Ludsteck.   \nThis package provides the following functions for seasonal \
adjustment:"
}], "Text",
 CellChangeTimes->{{3.6956278083408203`*^9, 3.6956279366845703`*^9}, {
  3.695629480100586*^9, 3.695629501647461*^9}, {3.695629531725586*^9, 
  3.695629679584961*^9}, {3.696134607640625*^9, 3.6961346791875*^9}},
 CellTags->"b:0"],

Cell[TextData[{
 "Season[",
 StyleBox["x,s",
  FontSlant->"Italic"],
 "]  splits the series ",
 StyleBox["x",
  FontSlant->"Italic"],
 " into trend, seasonal component, and irregular component, using estimated \
optimum smoothing parameters.\nSeason[",
 StyleBox["x,s,",
  FontSlant->"Italic"],
 "\[Alpha],\[Gamma]] splits the series ",
 StyleBox["x",
  FontSlant->"Italic"],
 " into trend, seasonal component, and irregular component, using the \
smoothing parameters \[Alpha] and \[Gamma]. \n\n",
 StyleBox["Both versions of Season[ ] return a list {{", "Commentary"],
 StyleBox["x,y", "Commentary",
  FontSlant->"Italic"],
 StyleBox[",", "Commentary"],
 StyleBox["z,u", "Commentary",
  FontSlant->"Italic"],
 StyleBox["},{\[Alpha],\[Gamma]},", "Commentary"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Sigma]", "2"], TraditionalForm]]],
 StyleBox["} where ", "Commentary"],
 StyleBox["x", "Commentary",
  FontSlant->"Italic"],
 StyleBox[" is the input series, ", "Commentary"],
 StyleBox["y", "Commentary",
  FontSlant->"Italic"],
 StyleBox[" is the trend, ", "Commentary"],
 StyleBox["z ", "Commentary",
  FontSlant->"Italic"],
 StyleBox["is the seasonal component, ", "Commentary"],
 StyleBox["u", "Commentary",
  FontSlant->"Italic"],
 StyleBox[" is the irregular component, \[Alpha] and \[Gamma] are the \
smoothing parameters used and ", "Commentary"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Sigma]", "2"], TraditionalForm]]],
 StyleBox[" is the variance of the irregular component..\n", "Commentary"],
 "\n",
 "LL",
 "[",
 StyleBox["x,s,",
  FontSlant->"Italic"],
 "\[Alpha],\[Gamma]] give the log likelihood of the constellation {",
 StyleBox["x,s",
  FontSlant->"Italic"],
 ",\[Alpha],\[Gamma]}.\n\nLLPlot[",
 StyleBox["x,s",
  FontSlant->"Italic"],
 ", {",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Alpha]", 
     StyleBox["max",
      FontSlant->"Italic"]], "}"}], TraditionalForm]]],
 ",{ ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["max",
     FontSlant->"Italic"]], TraditionalForm]]],
 "}] plots the log likelihood for the range {\[Alpha],\[Gamma]}\[Element][",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Alpha]", 
     StyleBox["max",
      FontSlant->"Italic"]], "]"}], TraditionalForm]]],
 "\[Times][",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["max",
     FontSlant->"Italic"]], TraditionalForm]]],
 "].\n"
}], "DefinitionBox",
 CellChangeTimes->{3.695534767182617*^9},
 CellTags->{"i:1", "b:0"}],

Cell[TextData[{
 "The method needs the time series ",
 StyleBox["x ",
  FontSlant->"Italic"],
 "and the length of the season ",
 StyleBox["s ",
  FontSlant->"Italic"],
 "as an input (",
 StyleBox["e.g",
  FontSlant->"Italic"],
 ". ",
 StyleBox["s",
  FontSlant->"Italic"],
 "=",
 StyleBox["4 ",
  FontSlant->"Italic"],
 "for quarterly data or ",
 StyleBox["s",
  FontSlant->"Italic"],
 "=",
 StyleBox["12",
  FontSlant->"Italic"],
 " for monthly data). The function Season[",
 StyleBox["x,s",
  FontSlant->"Italic"],
 "] computes smoothing parameters \[Alpha] and \[Gamma] by a maximum \
likelihood method and splits the time series, using these weights. \
Alternatively, the parameters can be provided in Season[",
 StyleBox["x,s",
  FontSlant->"Italic"],
 ",\[Alpha],\[Gamma]]. The parameter \[Alpha] controls the smoothness of the \
trend - the larger \[Alpha], the smoother the trend. The parameter \[Gamma] \
controls the rigidity of the seasonal pattern - the larger \[Gamma], the more \
time-invariant is the seasonal pattern. Both parameters interact: Increasing \
\[Alpha] while keeping \[Gamma] constant will shift some variabilty from the \
trend to the seasonal component, for example (and the rest to the irregular \
component). \nThe method assumes that trend, season and irregular component \
are ",
 StyleBox["additive",
  FontSlant->"Italic"],
 " components of the time series. For some time series, such as trended time \
series, a ",
 StyleBox["multiplicative",
  FontSlant->"Italic"],
 " formulation is preferable. In this case, take the logarithms of the \
original data as the input.\nInstructions: Place the package season6.m in \
$UserBaseDirectory\\Applications\\ (usually ",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", ":", 
    RowBox[{
     RowBox[{
      RowBox[{"\\", "Users"}], "\\<", "username"}], ">", 
     RowBox[{"\\", "AppData", "\\", "Roaming", "\\"}]}]}], TraditionalForm]]],
 "Mathematica\\ Applications\\) and successively  evaluate the cells.\nTo \
obtain information of the available functions, such as",
 StyleBox[" Season[],",
  FontFamily->"Courier New"],
 " evaluate it with a question mark, like ",
 StyleBox["?Season. ",
  FontFamily->"Courier New"],
 StyleBox["The list of of functions in the package season6.m  can be obtained \
by opening it oin ",
  FontFamily->"Times New Roman"],
 StyleBox["Mathematica",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 StyleBox[" and click on \[OpenCurlyDoubleQuote]",
  FontFamily->"Times New Roman"],
 StyleBox["Functions",
  FontFamily->"Segoe UI"],
 StyleBox["\[CloseCurlyDoubleQuote].",
  FontFamily->"Times New Roman"]
}], "Text",
 CellChangeTimes->{{3.6956163083222656`*^9, 3.6956164109785156`*^9}, {
   3.6956166953378906`*^9, 3.6956166991503906`*^9}, {3.695617980046875*^9, 
   3.695617995171875*^9}, {3.695618029140625*^9, 3.69561810528125*^9}, {
   3.695618161859375*^9, 3.695618178140625*^9}, {3.695618295921875*^9, 
   3.69561830728125*^9}, {3.6956183416933594`*^9, 3.6956184388496094`*^9}, {
   3.6956184771621094`*^9, 3.6956185456152344`*^9}, {3.695618920647461*^9, 
   3.695618938131836*^9}, 3.695619036053711*^9, {3.696093045375*^9, 
   3.696093077125*^9}, {3.696093162*^9, 3.696093169046875*^9}, {
   3.696093249602539*^9, 3.696093250336914*^9}, 3.696093408665039*^9, {
   3.696125797732422*^9, 3.696125798779297*^9}, 3.69612822078125*^9, {
   3.696135155953125*^9, 3.696135181625*^9}, {3.696135283834961*^9, 
   3.696135300084961*^9}, 3.6961354057822266`*^9, 3.696135475055664*^9, {
   3.696135549118164*^9, 3.696135579196289*^9}, {3.6961357522460938`*^9, 
   3.6961357946533203`*^9}}],

Cell["This loads the package", "MathCaption",
 CellTags->"b:0"],

Cell[BoxData[
 RowBox[{"<<", "Season6`"}]], "Input",
 CellChangeTimes->{
  3.695618898569336*^9, {3.6956202856054688`*^9, 3.6956202873398438`*^9}, {
   3.6956203358085938`*^9, 3.6956203370117188`*^9}, 3.6956204148710938`*^9, 
   3.6956205578447266`*^9, 3.695871867666086*^9},
 CellTags->"b:0",
 CellLabel->"In[1]:="],

Cell["\<\
Here is a series with 128 elements - the time series of monthly Gereman \
unemployment rates for 1992:01 through 2002:08.\
\>", "MathCaption",
 CellTags->"b:0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   StyleBox[
    RowBox[{
     StyleBox["{",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]], 
     RowBox[{
     "8.3", ",", "8.2", ",", "7.7", ",", "7.6", ",", "7.4", ",", "7.3", ",", 
      "7.8", ",", "7.7", ",", "7.5", ",", "7.6", ",", "7.7", ",", "8.1", ",", 
      "9", ",", "9", ",", "8.7", ",", "8.6", ",", "8.4", ",", "8.5", ",", 
      "9.1", ",", "9.1", ",", "8.9", ",", "9.1", ",", "9.2", ",", "9.6", ",", 
      "10.5", ",", "10.5", ",", "10.1", ",", "9.9", ",", "9.5", ",", "9.3", 
      ",", "9.6", ",", "9.4", ",", "9.1", ",", "8.9", ",", "8.9", ",", "9.2", 
      ",", "10", ",", "10", ",", "9.6", ",", "9.4", ",", "9", ",", "9", ",", 
      "9.4", ",", "9.3", ",", "9.2", ",", "9.2", ",", "9.3", ",", "9.9", ",", 
      "10.8", ",", "11.1", ",", "10.8", ",", "10.4", ",", "10", ",", "9.9", 
      ",", "10.2", ",", "10.2", ",", "10.1", ",", "10.1", ",", "10.3", ",", 
      "10.8", ",", "12.2", ",", "12.2", ",", "11.7", ",", "11.3", ",", "11.1",
       ",", "11", ",", "11.4", ",", "11.4", ",", "11.2", ",", "11.2", ",", 
      "11.3", ",", "11.8", ",", "12.6", ",", "12.6", ",", "12.1", ",", "11.4",
       ",", "10.9", ",", "10.5", ",", "10.7", ",", "10.6", ",", "10.3", ",", 
      "10.1", ",", "10.2", ",", "10.9", ",", "11.5", ",", "11.6", ",", "11.1",
       ",", "10.7", ",", "10.2", ",", "10.1", ",", "10.3", ",", "10.3", ",", 
      "10.1", ",", "9.9", ",", "10", ",", "10.3", ",", "11", ",", "10.9", ",",
       "10.6", ",", "9.8", ",", "9.3", ",", "9.1", ",", "9.3", ",", "9.3", 
      ",", "9", ",", "8.9", ",", "8.9", ",", "9.3", ",", "10", ",", "10.1", 
      ",", "9.8", ",", "9.5", ",", "9", ",", "8.9", ",", "9.2", ",", "9.2", 
      ",", "9", ",", "9", ",", "9.2", ",", "9.6", ",", "10.4", ",", "10.4", 
      ",", "10", ",", "9.7", ",", "9.5", ",", "9.5", ",", "9.7", ",", "9.6"}],
      "}"}],
    FontFamily->"Courier New",
    FontWeight->"Medium"]}], 
  StyleBox[";",
   FontFamily->"Courier New"]}]], "Input",
 CellTags->"b:0",
 CellLabel->"In[2]:="],

Cell[TextData[{
 "The following code calls the decomposition routine for monthly data with \
smoothing parameter values \[Alpha]=100 and \[Gamma]=100 and returns the list \
{{",
 StyleBox["x,y,z,u",
  FontSlant->"Italic"],
 "},{\[Alpha],\[Gamma]}}."
}], "MathCaption",
 CellChangeTimes->{{3.6956204273242188`*^9, 3.6956204291523438`*^9}},
 CellTags->"b:0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "\[Gamma]"}], "}"}], ",", "varU"}], "}"}], "=", 
   RowBox[{"Season", "[", 
    RowBox[{"x", ",", "12", ",", "100", ",", " ", "100"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.695535332426758*^9, 3.695535351786133*^9}, 
   3.695535503661133*^9, 3.695535539958008*^9, 3.697436132169922*^9},
 CellTags->"b:0",
 CellLabel->"In[3]:="],

Cell[TextData[{
 "Here is a plot of the original time series ",
 StyleBox["x ",
  FontSlant->"Italic"],
 "(red)",
 ", the trend ",
 StyleBox["y ",
  FontSlant->"Italic"],
 "(blue)",
 ", and the seasonal component ",
 StyleBox["z ",
  FontSlant->"Italic"],
 "(green)",
 "."
}], "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], " ", "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"1", ",", "0", ",", "0"}], "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0", ",", "0", ",", "1"}], "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0", ",", "1", ",", "0"}], "]"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJxdlFkuhEEUhSuePHrw4MHUZiJinumrzTR6njWR8GoLtQ1WUwtgL5ZAc47k
nko6la/uPXeqvyvz9Fp67gshxJ9fb/9bX9n3t94aNxzYy+8i99vnR2+Nggdg
Jw/an34EPGRrv4s8DB4Dj0u8CezkKYk/I/5ziMf6FiTOovAS4mXAy9CTVxCf
8Vax074Gf8ZbF96Anv6bYt9CfvI27JPgHezT2HeF9+A/Bd5HPuoPsJMPcR/M
l5V8Bj3s0aTeI99PFA4530/M4Zz1HXuOx5L/RPKf4Jz5Tz3HU+8fznx/8Uzm
ey71ncs8Lvz84gXsnPcl6p2B/VLsV9Czvyvp/1riX6Me2vOeY17u98ZzvEF+
2m99PfEW8eZgv/McybOwF6BHf1aQfgvwA6cC+gGHomcrIj71wqno84USGPVY
CfnnoRdOZPZXlvxkzqMMP3Aqox7eXwXxwFbx840VP/9Ukfur+nxWxTn6iVXo
wanq5xtqvh6ryfdQk/w1uf+6Z6vL91L331+qQ0d9Q/QNnPP+Gr6/1PDzCk3o
Ed+a8n9s+vckiT20PFsL59S3/HuThENb9G3fX2zL/Nq+3tDBzvrJzN+R/B15
X+49273ohZP4h65/D60r74lw6vr+wgPiUf/g+4nCSfzD43/+byC8waQ=
     "]]}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJw9lAlMU3ccxwsIKijeEbqi5RBQHHKDUuArICoeFHq3UAQPRFORKegqkDpn
FRFFVxAiOBA5MsjUMTxguhLUDBFQ2SxDxtgUwUTBe865OZf9fzZ5aT7v8z7J
7/3y3nNMTotbb87hcHTvj//+//89CUvP6Bg+4OsAdgJ1x8X1E3XE46Cym3C3
rYN4MjilslufOsxiPB3NncnDdzXEdmi8L6nQXyLmQZNsn/fcZjZjPmy1KgtL
BbETdr/NUdhVE7ugMDv8Z95LYleYbWvQ27jwGbtj7fBfj54JieehfZuqyvQZ
8XxkbXpo1d9E7Injlsmu2j+JvXA10Kv9QYgjY2+ktg0e89QT+4B/InX8zS5i
X+woqZE9m+nE2A9lZmEBJhWxP8JeSiYaSogD0HX9x6+7u4gDEdogLVf9TRwE
q5Q9b284OjNeCPfN0dKYEOJFWLftjWiqkDgY2S9KTkUpiQW44eac8kRFHIKW
OSllT8XEofC5pH3Ru4Q4DMH9baeGFhAD0yr7T7RNZ6wDau87mne+ovkWw3Du
bEFuD2PdYlgk+We3fkc+HH9o+2osq8mH43a0yTuniHwETMuLNx09TD4Cnj2d
9leOkI+EPmKLY0sp+UgIBgTVutPkl8DJt8PToo38EmTtlByxHSYfhY0NVYJi
G5o/CvKQpfYPfej+lmJUEiqam0B+KdzPVCjKcskvg5Jf3/D5efLL0C7ZpW8d
JL8cd0w1ddHTXJhfjjC3+S2/hzLmRGNv3Wn5oo3ko8HNeqDlFpBfAefAd559
58mvgB9vQdXoAPmV8P/BN7B8whzmV4LD7wkuD2bMWYWbdaFN/2jIr4LbkMO8
mEryq+HHnZ6U0Ut+NSYL+zMuTHFlPga/5l18dDCKsS4GDbd2inp2kBdigPcq
L6mKMYRoqDhiPtpJ1wuxxjbf4+JzxkYhau4e2/t8qhvrYyFdd85Y7MEYsRga
kIqKBIx1sehqt08fiWRsjEWtuERdG0F9HLy0AYLxQdTHIdm5sqLekfo47L5m
P/KSQ30c/PctLLc10fwihL8qd/GspvlF8Hnjml+WTvOLMMx3qS0W0PwiWG+5
sxbW1ItRP8mhtbWP7Q9ijHXKXKZspH2KYWFum37UwNgohjq/m7taS/uXwGoo
LXHNeuolGDxZaLgnol6CgsdPR69GUi9BmO+sy80B1EtxyTjQ0OtOvRTe+a4f
x3GplyIy0yM/x5p6Kc6P33V412t6fmToThsxbb/HGDJoCz7Rx16n502GQrMr
NpH1jI0yXNuaWu+cS70cM3ghvDFJ1MtxudG+qNyPejm8t3i4TbKkXo65/ClH
c7rp/VCgY/CjmbMqGEOBfvdjYT5b6X1SoHHhZn5WOGOjAhF2F8a62FOvRIdl
jNntF06sVyJo2iGn4p8Y65TIyGu2qW1mbFTiQF22NKiGMUeFs/LAyYZi6t/z
lNycvg/fGxVGu7pT3h2kXoXDbZMMPPKceLzu5LdwCqmPxxirqeXfllEfj6Jx
mbm/1VIfj6Z9ZzTu56hPwKA6dd+8q9QnoId3Uq/5MH8C9uTnCA49oD4Bv5T2
tHq+pl6NzBvfyLjWtD81bs2IM3zFo/2psf3LLzZs9qL9qXHA+qbN9x++54kI
6U16UxpPfSIiVqpma7ZTnwgHDTcNB6lPxMjopsj9ldSvQfTj/Rt0Tc74F0/s
Cys=
     "]]}, 
   {RGBColor[0, 1, 0], LineBox[CompressedData["
1:eJw91AtQVGUYBmCBwBAiRFSKgkV3GORiXJWLuC8ssCvscllYYNnl4trSeEVh
xlUEXJBAVFJURnRFqTC0yADHS4jtJihEKCiBgYC6FoY3TMc0TayG//PMnDnz
nm/mvM/85/zHSZklURlPmTJF89/5/3XyeMQrv+Co6J13n8duwNVTyJ/65B7L
b2NsLS+QnzTEsjWKrM0OBDueYtkWJe5lI4HdV3WT2Q4u1Uf9+L7XWf4AwQMW
1Q1eZ1nmoFM3IBqo62B5DjYFF2XGjA6yzMXuIi1mYoRlZ8zckB+kWDfAsgtK
X4YNvvf3AdbvivVlZ5ZxOeR3hzpYeSn0Ofnn40GBvTZBTX5P1Fh7Kneakt8L
37kcdpKPkd8bj9OKsyzCye8Ds025u345Q35fCDtUzQl68vvB790e0fE3/gXQ
HO7Z1S8i/0Lc3FiiK8kivz84PfYmUfkHWX8ATAYNDnu55A/EwcQuy/SZlINw
wIMvnWgn/yIkm/hqdbHkD4Zh31trjB6TfzE4Td59Lgnk5+FV7x5RxrEWloHm
WM+FdhPMrwFqVHd2/TpG/hAMq9fXTt/I/JoQbP7qi0rjYvKHou+BnUJ2pHqy
XxOKqtA/VB7O5OXDrf+hh58Pyxo+8hzPjDi+P8zmYRhP7Lp01pP5NWEwOmcd
scGmlz0/HKWWQ3JZDvNrwvHazVt99OE5No9ArFdhK0/8E5tHIK2n5fzBP8kv
gGr3oTQLLfkFqKs9sddjG/mF2Gcn4O6Pq2H9QjxVll/q8yf/EmzePkMjXUr+
JZByZ49P20H+SKzMCuGUzCN/JOY6NH7UwyV/FK6aD63JqSR/FCx2ZP5jodSx
uQitRuLz9Vryi6BznRBzTOl9iTFv5YMms4vkF2PdnXemZ+wkfzTcSvdvzVZ9
zvqjEdD70mGZkPwxqFOEZUXmkz8Gssa73QXXyB+Lnn3j7Xn9JyczYvGs3kuY
F8D8mlic5X8zy6qRefSxMOxZXmbF07P+OBhrrhnWf8/8iMMPNZ90x5FfE4fM
hrLti/qZXx+HgirxjPpc8ksgPzzXYlXJl6xfgurcC7e5oeSV4Ea7e1/bDpb1
EvgUmToauYwwfzxObQpqLRolfzxCBJ/qnCPJH4+TibNuz2olfzwKrPm3nnaS
PwFDQR0ThwzkT4Ag83pKzDTyJ6BT1BwveUL+BJyzO2aiUpNfCo5p+Mbxo7Ws
X4rCYLvs027kl+JWV5W9eQn5pSgejuaFR5M/EfctLw+sfEH+RCzt+7BFKCV/
IsSwNec3kD8Rc5ynZ2qn/sj6k9Ck9x0+cYX8SRDemHHR6RH7/jVJ2F2Rk5Nk
IH8S1B8P2pRLyJ+MnVGepVL7I6w/GV5NLRVb7cmfjNdKc33HBvIn42lz+r0t
q8gvQ1d59/68u+SXYb6y7Vl6KvllWLu58fLNI+SXYUL9u2BbMPlTUPnKVPv1
m/VPQUGzbaEX7V9NCmBptdfqOvlT4Gdm7+/JJ78cpWq59+K55JdjtdTH+bg5
+eVY7pp9MmgF+eXY4vdZeIiS/Aq0NDx8MerA9i8UyDU2nM4Xk18BG0HA2MIS
8itQaGNR+YxH/lS4tZ+qCntC/lSs/q3Xv3Oc/KmwbXPcPtBL/lTUHXNa/bM7
+dMQGnjFKmMd+dPw1+v7W+rNyJ+GBRWXZ2fT/0efhm+fK8slkeRPx4D5bZ8l
t2j90+GgsoyoDSV/OsKLQzJkK8ifjmX+bRVFgeTPQLN55mjXtE7dvyJhfas=

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 128.}, {-0.4836011712697653, 12.6}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.695874981757883*^9, 3.695875117882883*^9, 
  3.695876101356516*^9, 3.695978422720703*^9, 3.696134855625*^9, 
  3.696213158341797*^9, 3.697436008763672*^9, 3.697436157263672*^9, 
  3.697436262857422*^9},
 CellLabel->"Out[4]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "Subsection",
 CellChangeTimes->{{3.69587363881843*^9, 3.69587364066218*^9}}],

Cell[CellGroupData[{

Cell["", "Subsubsection",
 CellChangeTimes->{{3.695873618490305*^9, 3.695873621677805*^9}}],

Cell[TextData[{
 "To view the effect of the choice of the smoothing parameters \[Alpha] and \
\[Gamma] over the ranges (",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Alpha]", "min"], ",", 
   SubscriptBox["\[Alpha]", "max"]}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}}],
 ") and (",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[Gamma]", "min"], ",", 
     SubscriptBox["\[Gamma]", "max"]}], ")"}], " "}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}}],
 "evaluate the following. It uses  ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Alpha]", "init"], "=", "10"}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}, {3.695874533227609*^9, 
    3.695874548227609*^9}}],
 ", ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Alpha]", "min"], "=", ".1"}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}, {3.695874533227609*^9, 
    3.695874548227609*^9}}],
 ", ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Alpha]", "max"], "=", "100"}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}, {3.695874533227609*^9, 
    3.695874548227609*^9}}],
 ",  ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "init"], "=", "10"}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}, {3.695874533227609*^9, 
    3.695874548227609*^9}}],
 ", ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "min"], "=", ".1"}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}, {3.695874533227609*^9, 
    3.695874548227609*^9}}],
 ", ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "max"], "=", "100"}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}, {3.695874533227609*^9, 
    3.695874548227609*^9}}],
 "."
}], "MathCaption",
 CellChangeTimes->{{3.6958736996807346`*^9, 3.6958737673369846`*^9}, {
  3.6958738708994846`*^9, 3.6958739382119846`*^9}, {3.6958743052744846`*^9, 
  3.695874386321359*^9}, {3.6958747282119846`*^9, 3.6958747323369846`*^9}, {
  3.695874784383859*^9, 3.695874879977609*^9}}],

Cell["", "Text",
 CellChangeTimes->{{3.6958736895557346`*^9, 3.6958736945557346`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", ",", "\[Gamma]"}], "}"}], ",", "varU"}], "}"}], 
     "=", 
     RowBox[{"Season", "[", 
      RowBox[{"x", ",", "12", ",", "\[Alpha]", ",", " ", "\[Gamma]"}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"ListPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], " ", "}"}], ",", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"RGBColor", "[", 
             RowBox[{"1", ",", "0", ",", "0"}], "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"RGBColor", "[", 
             RowBox[{"0", ",", "0", ",", "1"}], "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"RGBColor", "[", 
             RowBox[{"0", ",", "1", ",", "0"}], "]"}], "}"}]}], "}"}]}]}], 
       "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"\"\<\[Alpha] =  \>\"", "  ", "<>", " ", 
            RowBox[{"ToString", "[", " ", "\[Alpha]", " ", "]"}], "<>", " ", 
            "\"\<    \[Gamma] =  \>\"", "  ", "<>", " ", 
            RowBox[{"ToString", "[", " ", "\[Gamma]", " ", "]"}], "<>", 
            "\"\<\\nLogLikelihood = \>\"", "<>", 
            RowBox[{"ToString", "[", 
             RowBox[{"LL", "[", 
              RowBox[{"x", ",", "12", ",", "\[Alpha]", ",", "\[Gamma]"}], 
              "]"}], "]"}]}], ",", "12", ",", 
           RowBox[{"TextAlignment", "\[Rule]", "Left"}]}], "]"}], ",", "  ", 
         RowBox[{"{", 
          RowBox[{"80", ",", "5.5"}], "}"}]}], "]"}], "]"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "10"}], "}"}], ",", ".1", ",", "100"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Gamma]", ",", "10"}], "}"}], ",", ".1", ",", "100"}], 
    "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6958746470244846`*^9, 3.695874651696359*^9}, {
  3.6958746905869846`*^9, 3.6958746938369846`*^9}, {3.695874738290109*^9, 
  3.6958747603057346`*^9}, {3.6959781294257812`*^9, 3.6959781535126953`*^9}, {
  3.697435994482422*^9, 3.697435996935547*^9}},
 CellLabel->"In[5]:="],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Alpha]$$ = 10, $CellContext`\[Gamma]$$ = 
    10, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Alpha]$$], 10}, 0.1, 100}, {{
       Hold[$CellContext`\[Gamma]$$], 10}, 0.1, 100}}, Typeset`size$$ = {
    360., {109., 113.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Alpha]$122$$ = 
    0, $CellContext`\[Gamma]$127$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`\[Alpha]$$ = 10, $CellContext`\[Gamma]$$ = 
        10}, "ControllerVariables" :> {
        Hold[$CellContext`\[Alpha]$$, $CellContext`\[Alpha]$122$$, 0], 
        Hold[$CellContext`\[Gamma]$$, $CellContext`\[Gamma]$127$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ({{$CellContext`x, $CellContext`y, $CellContext`z, \
$CellContext`u}, {$CellContext`\[Alpha]$$, $CellContext`\[Gamma]$$}, \
$CellContext`varU} = 
        Season`Season`Season[$CellContext`x, 
          12, $CellContext`\[Alpha]$$, $CellContext`\[Gamma]$$]; Show[
         ListPlot[{$CellContext`x, $CellContext`y, $CellContext`z}, Joined -> 
          True, PlotStyle -> {{
             RGBColor[1, 0, 0]}, {
             RGBColor[0, 0, 1]}, {
             RGBColor[0, 1, 0]}}], 
         Graphics[
          Text[
           Style[
            StringJoin["\[Alpha] =  ", 
             ToString[$CellContext`\[Alpha]$$], "    \[Gamma] =  ", 
             ToString[$CellContext`\[Gamma]$$], "\nLogLikelihood = ", 
             ToString[
              Season`Season`LL[$CellContext`x, 
               12, $CellContext`\[Alpha]$$, $CellContext`\[Gamma]$$]]], 12, 
            TextAlignment -> Left], {80, 5.5}]]]), 
      "Specifications" :> {{{$CellContext`\[Alpha]$$, 10}, 0.1, 
         100}, {{$CellContext`\[Gamma]$$, 10}, 0.1, 100}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{405., {167., 172.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.6958746528369846`*^9, 3.6958746974307346`*^9, 
  3.6958747662744846`*^9, 3.6958749023369846`*^9, 3.695874981929758*^9, 
  3.695875118039133*^9, 3.695876102606516*^9, 3.6959781549365234`*^9, 
  3.695978424053711*^9, 3.696134856703125*^9, 3.696213159435547*^9, 
  3.697436010044922*^9, 3.697436157435547*^9, 3.697436263076172*^9},
 CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
 "If Season is called without smoothing parameters, it computes the optimum \
smoothing parameters by a maximum-likelihood method and returns the list  {{",
 StyleBox["x,y,z,u",
  FontSlant->"Italic"],
 "},{\[Alpha],\[Gamma]},",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Sigma]", "2"], TraditionalForm]]],
 "}."
}], "MathCaption",
 CellTags->"b:0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "g"}], "}"}], ",", "var"}], "}"}], "=", 
   RowBox[{"Season", "[", 
    RowBox[{"x", ",", "12"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6955508907978516`*^9, 3.6955509151572266`*^9}, {
  3.6955534494228516`*^9, 3.6955535225478516`*^9}, {3.6955538661210938`*^9, 
  3.6955538896367188`*^9}},
 CellTags->"b:0",
 CellLabel->"In[6]:="],

Cell[TextData[{
 "Here is a plot of the original time series ",
 StyleBox["x ",
  FontSlant->"Italic"],
 "(red), the trend ",
 StyleBox["y ",
  FontSlant->"Italic"],
 "(blue), and the seasonal component ",
 StyleBox["z ",
  FontSlant->"Italic"],
 "(green). It can be seen that the smoothing parameters are estimated smaller \
than the parameters used in the previous example. In particular, the \
parameter \[Alpha] for the trend is estimated as being quite small, entailing \
a rougher trend."
}], "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], " ", "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"1", ",", "0", ",", "0"}], "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0", ",", "0", ",", "1"}], "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0", ",", "1", ",", "0"}], "]"}], "}"}]}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Smoothing parameters: \[Alpha] = \>\"", ",", "a", ",", 
    "\"\<,  \[Gamma] = \>\"", ",", "g"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Estimated variances: \!\(\*SuperscriptBox[SubscriptBox[\(\[Sigma]\), \
\(u\)], \(2\)]\) = \>\"", ",", " ", "varU", ",", " ", 
    "\"\<, \!\(\*SuperscriptBox[SubscriptBox[\(\[Sigma]\), \(v\)], \(2\)]\) = \
\>\"", ",", 
    RowBox[{"varU", "/", "a"}], ",", 
    "\"\<, \!\(\*SuperscriptBox[SubscriptBox[\(\[Sigma]\), \(w\)], \(2\)]\) = \
\>\"", ",", 
    RowBox[{"varU", "/", "g"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6954469302646484`*^9, 3.6954470281396484`*^9}, {
  3.6956204562148438`*^9, 3.6956204567773438`*^9}},
 CellLabel->"In[7]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJxdlFkuhEEUhSuePHrw4MHUZiJinumrzTR6njWR8GoLtQ1WUwtgL5ZAc47k
nko6la/uPXeqvyvz9Fp67gshxJ9fb/9bX9n3t94aNxzYy+8i99vnR2+Nggdg
Jw/an34EPGRrv4s8DB4Dj0u8CezkKYk/I/5ziMf6FiTOovAS4mXAy9CTVxCf
8Vax074Gf8ZbF96Anv6bYt9CfvI27JPgHezT2HeF9+A/Bd5HPuoPsJMPcR/M
l5V8Bj3s0aTeI99PFA4530/M4Zz1HXuOx5L/RPKf4Jz5Tz3HU+8fznx/8Uzm
ey71ncs8Lvz84gXsnPcl6p2B/VLsV9Czvyvp/1riX6Me2vOeY17u98ZzvEF+
2m99PfEW8eZgv/McybOwF6BHf1aQfgvwA6cC+gGHomcrIj71wqno84USGPVY
CfnnoRdOZPZXlvxkzqMMP3Aqox7eXwXxwFbx840VP/9Ukfur+nxWxTn6iVXo
wanq5xtqvh6ryfdQk/w1uf+6Z6vL91L331+qQ0d9Q/QNnPP+Gr6/1PDzCk3o
Ed+a8n9s+vckiT20PFsL59S3/HuThENb9G3fX2zL/Nq+3tDBzvrJzN+R/B15
X+49273ohZP4h65/D60r74lw6vr+wgPiUf/g+4nCSfzD43/+byC8waQ=
     "]]}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJw91QlMk3ccxnFEUUBZgGDQoYxThsOiIqhM4KEFWgSxd0vhbQGt54SggoWJ
a5AhijLEawo6FRWcBziHREXtFDxQCYIbitucgqkyjiHzCgy3Zf/fmjTNh6ff
5OXft6l7SppUb2lhYWH85/nv63+PP8IkBeGpJ3Mng/0BtuL+Dv0msjWUhVka
03GyPZpqP/MxjHJldkJ78oGu3mzyBJSW7yqeYCZPgtc3Ib+VCT9idsNYUbZA
sJvsgdKpJc1dD8leGIjsab1r48Y8Bfp1I6KvuZI/RuDy3hxnHnkqRr3Pl7wI
J/tB1G/pFbyMzIPbgxb31OPk6bhvVdx4aJg8A4kTv5/es8ideSaWmipe/dhC
DkBPUVR96VwP5lnI6DlXsaCQHIhLvo02QY3kIPhGpFXIRngyz0ae64yL9zzJ
c9BR9Ts3EESei6FjSWM+jyIHo/rOwb4v48mf4phEXbQtnTwPN6u2jZblk0OQ
PjYvZ18BORT53JWbXCY5DH1624JlKjKgm21eL/dnNgKa5KlF04bp+sPxCfc8
Kb+e2RiOJOPKgGnbaefj7J2s3PN62vlQrWmv4cXQLoCiM6bdEE27AD5N6hWH
dLRHoFfbOhiSR3sENjz10Z+toD0Sr+uiLPc10R6JiiHrhLt9tEfB6cPebsM4
uv4oFHUu8hvk0f8nhOr6HM5CTrsQgbFVzZFG2kU4nJabLqqjXYSZiz3rjr+n
PRrxG37Y3yX2Yns0HGveJv+yldliPtxurTOllNM+H6/8V/eUHaU9BlmXjbXL
j9EeA0N5aN7h07THYtA0xF/aSHss0rZneA+8pn0BGgyXfA/4e7N9AZrjbJLe
ZDFbxGFyX95NQRvtcXC44TIYyp/C9oXIuiE8M87AbFyIlPnPds3YTLsYAudH
9iFlzBDj27r00CdX6P1iBKZoiu91MpvEOORYP/KqtQ/rJXhppbBa7sMMCS5I
q5PHCZiNEjgMW1muTGI2SZC/Z28GP5N6KRweiG27v6BeCh4/YdXeDOql8F3N
G/haQb0Uz111Yx5PoF6GsMrW9pLLdP0yJOsqnyk5un4ZijZsfRY8zM7HJMNg
TsnCinN0fnIsEd1Y1rGRGXK8tHa5/U5H5ynH7c5rtaPjqJfj590p0V5K6hV4
KovkklZQr4CT8ETI7EXUK8Af/91PWgX1CmQe4V3eGUa9EtUlO2zs6POFEksy
y2tOTqReCfWs53FrbKlXon+Lpt/5L7o/VHB/LJlbRvcLVLBzHxrR00P3kwqv
JkpjuTZmkwr37QO4LeeoV+MDl84LFvnUq+Hn3cQ1yKhXQydY9zDElXo1tr4w
8tI66fsRjzrvexlvipkRD/PaaYdzoun7FA9/R1mUizOzKR5pEeVB7u88WK9B
S6XXYjczMzQYeSbzSm8zs1GDtprd8sYaZpMGVm2F1ok7qE9AamPDGJGB+gRc
v6ixclxFfQLs/lQd3JxNfQLWCuc83byT+kRoE3PzdCeoT0T3wVHjzSepT0Tl
4NI7qaepT8STkauv6s9Tz6G6q37KtVvUc2jYY9+271fqOay/bzYveUs9B3XJ
o6gTdnR+WjgWOjzud6Lz04K3syP46ng6Py32P8guDSCbtJiX3qA7+v/vhw6L
u/y6v4qjXofWPVWTPDZRr8PGI4KW8NPU6/Cy6U2msJb6JBzpP3WqtcoTfwNA
Xhm/
     "]]}, 
   {RGBColor[0, 1, 0], LineBox[CompressedData["
1:eJw9lAs0lGkYx8cluaTUSnZjbbFW2S5iZDbWn5EMYoZxv4yKw66zlJPUbvSp
JCe5pei2as/olFNtlFKtY0pKN5lKchkUlXLtstpU2vZ43v3OmfOd//y/5/3/
zvM+7ztrZaJfjDqPx+M+//57jz/DzlKj7duFx/qd6Q+clQcVFOMFaW287a2q
6FrZRNoAUZIh/uujF0gb4tZoeFKdbWPNuDaG+uVKlXCklbQJQvdBeheHSH+D
rSYz7thsric9GyKZSpYvUJG2wJoLztk98W2kLdHgezN38ptm0lbIfrQ/kC+J
o/y5aDVcfn2VHeP/Hl+cP3fcJpLxz0emlk94h3sz6YVIFfNfNKy/SNoGfKGO
z709Slp/EYxKDDP7exm/LczfVekm/SonbYddQ+dP2ugwfj7C8s2DHve3k7aH
o2GdX0cr41+MSQn3izf88pC0A6qO91yCl4TyBXhwctj+WF8f6R8QYjGhy+Mt
41+CuLTfr7lptJB2hP+NgFRd82rSTljR/mE4l3+X1v8RDuce38g0YfnO+HZr
mVXSulOkAdduxQmdS8TPAfbdwY6fNNj3LtDM3X37wGraD84F0Qf8HsbHtpDv
Cq+sKw8HB38ez+dcEVW9VRjTyPiFqPmr9EfZE9KcEC3x6qZ2c9rId0Oy/uDh
vlc0P5wb5NZ6g2FR92j9pVjgIxmaqkk83FJkavCSBmoqyXcH71KEv1XOdfLd
4Vk+0qetxvZrGbJiQ/30ZneQvwxvRKdz0c18D6htiI+yXLKO8j3Q5jRhj9ZE
Nj8iWG/ctuOJ7gD5IiToCS5nKlTke+LZ2cR+i97T5HtCdFtunbGD8XvhSXrT
qsRCxu+FetGw+iynavK9sSs9JfdwHuu/N5IdzFyGS1l/l6OqmsvbPbmT/OWI
y1Wap3uy/fHB6JjdJpPpW8j3gXrvPeX8JOLl+cLgQfOa5hLG74uZ0ob9vLgO
8sXI5DtOXjH12LiGGBk9w5WGRsTPibEzQcgLl9E8K8QojVGoTNMVlC+BwQfX
9y6Ca+MaEoy6h7jUjRA/J8HmknbTm/XEr5DgZYzApG0x4/fDTqXFU3dtOeX7
wfuAa2WFFfWf88P2r/qKtdOIX+GH1fq+xg6eXcTvDzVptnthbRnV+6NYxR3i
pzF+f4ydzAs2G2P8/nhePlqqEtdSvhRjC5WeC9yuEr8U02xdy/NljF8Kj23Z
gsjYLqqX4t28NLWR/89HAH5ykf2dEVNJ+QFoMM2Zgqls3gPQ+8/R4IyJjD8A
yYni99EFjD8QWgFflmwcKKf6QKyYnbBWr/Q+5QdimmVyrXyU8hSB+HT1dI5l
SR3lB8E+WpXZc4TxB6Hd18B1/kzGH4Ss5H0Dk8wZfxCKbFKtlAZsvoIhrLxl
XaDB8oPxtaizP/kC3TdcMHzOfD4dRrQfimAs6fot8/KWR8QfArNULd0hjtWH
4ENKjMC7jfGHoLErRPqyiPGH4OAhDc2nxsTLC4XbzOCDm4YZfyjKTozOMxhi
/KHoVGz+Uz6dzU8omsxebbxtwu7PMCxaOimwKuMU5Yehr+X1/sJoxh+Gqr3S
95Y1tB+KMMwzUBNpJrP+h+OppHuoyLiK6sPRu/6l4agT4w/H2rmvUiyO0H2h
CIeuTkthYwrrfwSiLopre+fQ/YMIWJXpNT47Tt9zEdiiLJiSo8/4I7DXTF+r
qeMB1UfiqOAPtzEw/kg05KSf6b/O+CPRWu/RkCJn/JGoiOU+Jt9h51eG+Fn5
/RWr6f6BDB+fF0XtmMDmX4YbFUYpM5TUL4UMks43a/K6rlB+FBoXfZdlG3qz
5l+C7Ixl
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 128.}, {-0.5126181720735952, 12.6}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.6954470289365234`*^9, 3.695447830908203*^9, 
  3.6955546609960938`*^9, 3.6955553299628906`*^9, 3.695611722571289*^9, 
  3.6956204507617188`*^9, 3.6956222926103516`*^9, 3.6957341040117188`*^9, 
  3.695822017029297*^9, 3.6958227839492188`*^9, 3.6958718342442107`*^9, 
  3.695871889697336*^9, 3.695872345740305*^9, 3.695874987382883*^9, 
  3.695875123632883*^9, 3.695876108372141*^9, 3.6959784287646484`*^9, 
  3.696134862515625*^9, 3.696213165232422*^9, 3.697436014638672*^9, 
  3.697436163544922*^9, 3.697436268919922*^9},
 CellLabel->"Out[7]=",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Smoothing parameters: \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.9237079229964356`", "\[InvisibleSpace]", "\<\",  \[Gamma] = \"\>", 
   "\[InvisibleSpace]", "1.8873598264206757`"}],
  SequenceForm[
  "Smoothing parameters: \[Alpha] = ", 0.9237079229964356, ",  \[Gamma] = ", 
   1.8873598264206757`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6954469701240234`*^9, 3.6954470290458984`*^9}, 
   3.695447830986328*^9, 3.6955546611210938`*^9, 3.6955553300566406`*^9, 
   3.695611722649414*^9, 3.6956204508867188`*^9, 3.6956222927197266`*^9, 
   3.6957341040742188`*^9, 3.695822017060547*^9, 3.6958227839960938`*^9, 
   3.6958718342754607`*^9, 3.6958718897129607`*^9, 3.69587234575593*^9, 
   3.695874987429758*^9, 3.695875123695383*^9, 3.695876108387766*^9, 
   3.695978428798828*^9, 3.69613486253125*^9, 3.696213165263672*^9, 
   3.697436014669922*^9, 3.697436163607422*^9, 3.697436268951172*^9},
 CellLabel->"During evaluation of In[7]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estimated variances: \\!\\(\\*SuperscriptBox[SubscriptBox[\\(\
\[Sigma]\\), \\(u\\)], \\(2\\)]\\) = \"\>", "\[InvisibleSpace]", 
   "0.007199972615531286`", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SuperscriptBox[SubscriptBox[\\(\
\[Sigma]\\), \\(v\\)], \\(2\\)]\\) = \"\>", "\[InvisibleSpace]", 
   "0.007794642046779401`", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SuperscriptBox[SubscriptBox[\\(\
\[Sigma]\\), \\(w\\)], \\(2\\)]\\) = \"\>", "\[InvisibleSpace]", 
   "0.0038148383338146123`"}],
  SequenceForm[
  "Estimated variances: \!\(\*SuperscriptBox[SubscriptBox[\(\[Sigma]\), \
\(u\)], \(2\)]\) = ", 0.007199972615531286, 
   ", \!\(\*SuperscriptBox[SubscriptBox[\(\[Sigma]\), \(v\)], \(2\)]\) = ", 
   0.007794642046779401, 
   ", \!\(\*SuperscriptBox[SubscriptBox[\(\[Sigma]\), \(w\)], \(2\)]\) = ", 
   0.0038148383338146123`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6954469701240234`*^9, 3.6954470290458984`*^9}, 
   3.695447830986328*^9, 3.6955546611210938`*^9, 3.6955553300566406`*^9, 
   3.695611722649414*^9, 3.6956204508867188`*^9, 3.6956222927197266`*^9, 
   3.6957341040742188`*^9, 3.695822017060547*^9, 3.6958227839960938`*^9, 
   3.6958718342754607`*^9, 3.6958718897129607`*^9, 3.69587234575593*^9, 
   3.695874987429758*^9, 3.695875123695383*^9, 3.695876108387766*^9, 
   3.695978428798828*^9, 3.69613486253125*^9, 3.696213165263672*^9, 
   3.697436014669922*^9, 3.697436163607422*^9, 3.697436268982422*^9},
 CellLabel->"During evaluation of In[7]:="]
}, Open  ]],

Cell[TextData[{
 "The option \"SearchRange\" \[Rule] {{",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Alpha]", 
     StyleBox["max",
      FontSlant->"Italic"]], "}"}], TraditionalForm]]],
 ", {",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Gamma]", 
     StyleBox["max",
      FontSlant->"Italic"]], "}"}], TraditionalForm]]],
 "} permits to select a range over which Season searches for a solution, \
where \[Alpha] is restricted to the interval [",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["max",
     FontSlant->"Italic"]], TraditionalForm]]],
 "] and \[Gamma] is restricted to the interval [",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["max",
     FontSlant->"Italic"]], TraditionalForm]]],
 "]. If a parameter is estimated close to the boundary of the relevant \
interval, a warning is issued.\n\n",
 StyleBox["The standard option for the search range is: \"SearchRange\"  \
\[Rule]  {{0.5, 1000}, {0.5, 1000}}.", "Commentary"]
}], "DefinitionBox",
 CellChangeTimes->{{3.695611767165039*^9, 3.695611776899414*^9}},
 CellTags->"b:0"],

Cell["Here is an example:", "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Alpha]", ",", "\[Gamma]"}], "}"}], ",", " ", "var"}], "}"}],
     "=", 
    RowBox[{"Season", "[", 
     RowBox[{"x", ",", "12", ",", " ", 
      RowBox[{"\"\<SearchRange\>\"", " ", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "10"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "10"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.6955552070878906`*^9, 3.6955552384160156`*^9}, {
   3.6955552702285156`*^9, 3.6955552886191406`*^9}, {3.695611790790039*^9, 
   3.695611808805664*^9}, 3.697436220123047*^9},
 CellLabel->"In[10]:="],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Season", "::", "cornera"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Estimate \[NoBreak]\\!\\(1.0000000783988976`\\)\[NoBreak] \
of alpha appears to be a corner solution\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.695611820430664*^9, 3.6956204747460938`*^9, 
  3.6956223032822266`*^9, 3.6956276480126953`*^9, 3.6957341092460938`*^9, 
  3.695822022638672*^9, 3.6958227930898438`*^9, 3.695871834353586*^9, 
  3.695871896072336*^9, 3.695872351240305*^9, 3.695874992757883*^9, 
  3.695875129070383*^9, 3.695876113981516*^9, 3.6959784346445312`*^9, 
  3.69613486809375*^9, 3.696213170841797*^9, 3.697436019951172*^9, 
  3.697436169107422*^9, 3.697436274326172*^9},
 CellLabel->"During evaluation of In[10]:="]
}, Open  ]],

Cell[TextData[{
 "Season calls NMaximize to determine the optimum smoothing parameter. \
NMaximize options can be given to Season to cope with convergency problems \
and other issues. They are handed over to NMaximize. If NMaximize does not \
find a solution, a warning is issued.\n\n",
 StyleBox["Standard options for NMaximize in Season are: Method \[Rule] \
{\"NelderMead\", PostProcess \[Rule] False }. To speed up calculation, use \
AccuracyGoal \[Rule] 3.", "Commentary"]
}], "DefinitionBox",
 CellTags->"b:0"],

Cell["Here is an example:", "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Alpha]", ",", "\[Gamma]"}], "}"}], ",", " ", "var"}], "}"}],
     "=", 
    RowBox[{"Season", "[", 
     RowBox[{"x", ",", "12", ",", 
      RowBox[{"AccuracyGoal", "\[Rule]", "8"}], ",", 
      RowBox[{"MaxIterations", "\[Rule]", "5"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{3.697436228248047*^9},
 CellLabel->"In[11]:="],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NMaximize", "::", "cvmit"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Failed to converge to the requested accuracy or precision \
within \[NoBreak]\\!\\(5\\)\[NoBreak] iterations. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/NMaximize\\\", ButtonNote -> \
\\\"NMaximize::cvmit\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.695611838993164*^9, 3.6956204823085938`*^9, 
  3.6956223117509766`*^9, 3.6957341102617188`*^9, 3.695822023888672*^9, 
  3.6958227984492188`*^9, 3.6958718344004607`*^9, 3.6958718971192107`*^9, 
  3.695872352146555*^9, 3.695874993664133*^9, 3.695875130007883*^9, 
  3.695876114872141*^9, 3.695978435821289*^9, 3.696134869046875*^9, 
  3.696213171763672*^9, 3.697436021044922*^9, 3.697436170466797*^9, 
  3.697436275576172*^9},
 CellLabel->"During evaluation of In[11]:="],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Season", "::", "maxfail"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Aborting due to problems in numerical maximization \
procedure.\\n Consider fine-tuning of NMaximize options.\"\>"}]], "Message", \
"MSG",
 CellChangeTimes->{3.695611838993164*^9, 3.6956204823085938`*^9, 
  3.6956223117509766`*^9, 3.6957341102617188`*^9, 3.695822023888672*^9, 
  3.6958227984492188`*^9, 3.6958718344004607`*^9, 3.6958718971192107`*^9, 
  3.695872352146555*^9, 3.695874993664133*^9, 3.695875130007883*^9, 
  3.695876114872141*^9, 3.695978435821289*^9, 3.696134869046875*^9, 
  3.696213171763672*^9, 3.697436021044922*^9, 3.697436170466797*^9, 
  3.697436275607422*^9},
 CellLabel->"During evaluation of In[11]:="],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.695871897228586*^9, 3.69587235219343*^9, 
  3.695874993742258*^9, 3.695875130117258*^9, 3.695876114950266*^9, 
  3.695978435923828*^9, 3.696134869125*^9, 3.696213171826172*^9, 
  3.697436021138672*^9, 3.697436170560547*^9, 3.697436275654297*^9},
 CellLabel->"Out[11]="]
}, Open  ]],

Cell[TextData[{
 "The function LL[",
 StyleBox["x,s",
  FontSlant->"Italic"],
 ",",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", ","}], TraditionalForm]]],
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 "] returns the log likelihood of the constellation {",
 StyleBox["x,s",
  FontSlant->"Italic"],
 ",",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", ","}], TraditionalForm]]],
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 "}."
}], "DefinitionBox",
 CellChangeTimes->{{3.695534731666992*^9, 3.695534734073242*^9}},
 CellTags->"b:0"],

Cell["Here is an example:", "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LL", "[", 
  RowBox[{"x", ",", "12", ",", "2", ",", "3"}], "]"}]], "Input",
 CellChangeTimes->{3.695534757026367*^9},
 CellLabel->"In[12]:="],

Cell[BoxData["681.7806689358488`"], "Output",
 CellChangeTimes->{3.6955536354804688`*^9, 3.6955538001054688`*^9, 
  3.6955543704960938`*^9, 3.695611856665039*^9, 3.6956204935117188`*^9, 
  3.6956223172822266`*^9, 3.6956277003720703`*^9, 3.6957341105585938`*^9, 
  3.695822024216797*^9, 3.6958228040429688`*^9, 3.695871834416086*^9, 
  3.6958718974942107`*^9, 3.69587235231843*^9, 3.695874993898508*^9, 
  3.695875130304758*^9, 3.695876115106516*^9, 3.6959784361503906`*^9, 
  3.69613486928125*^9, 3.696213171951172*^9, 3.697436021341797*^9, 
  3.697436170841797*^9, 3.697436275919922*^9},
 CellLabel->"Out[12]="]
}, Open  ]],

Cell[TextData[{
 "The function LLPlot[x,s,{",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Alpha]", 
     StyleBox["max",
      FontSlant->"Italic"]], "}"}], TraditionalForm]]],
 ", {",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Gamma]", 
     StyleBox["max",
      FontSlant->"Italic"]], "}"}], TraditionalForm]]],
 "] returns a plot of the log likelihood over the range {\[Alpha],\[Gamma]}\
\[Element][",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Alpha]", 
     StyleBox["max",
      FontSlant->"Italic"]], "]"}], TraditionalForm]]],
 "\[Times][",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["max",
     FontSlant->"Italic"]], TraditionalForm]]],
 "].\n\n",
 StyleBox["LLPlot calls Plot3D and hands any options over to Plot3D. Be aware \
that the system matrix becomes near-singular for very large or very small \
values of the smoothing parameters, and that irregularities in these regions \
may be computational artifacts.", "Commentary"]
}], "DefinitionBox",
 CellTags->"b:0"],

Cell["Here is an example:", "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LLPlot", "[", 
  RowBox[{"x", ",", "12", ",", 
   RowBox[{"{", 
    RowBox[{"0.9", ",", "0.95"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.8", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotPoints", " ", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6955553828378906`*^9, 3.6955553890722656`*^9}, 
   3.6955555022910156`*^9, {3.6955558308222656`*^9, 3.6955558418691406`*^9}, {
   3.6955559495410156`*^9, 3.6955559570566406`*^9}, 3.695556310560547*^9, 
   3.695556382888672*^9, {3.695556500779297*^9, 3.695556509529297*^9}, {
   3.6956161581972656`*^9, 3.6956161816660156`*^9}},
 CellLabel->"In[13]:="],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx93XlcTG//P/CKlChJkYjSvimSIjnZEpJsKUtJiqRIyhYqW0K2LFFZKsnS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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmgn4FdMfxu/MPfe0quwqJUuUiFD5E0WL7Cr7LpEsRbZ2WrRQSovQIopW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         "]], Polygon3DBox[CompressedData["
1:eJw1m3ngDtX/xWfmzh2KFolIylLSQqVo0UKotJGKCokKUaLFUlpISmnXvpc2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         "]], Polygon3DBox[CompressedData["
1:eJwt12W4VUUbBuAThCAtoXR3o4R0HbrzAAoogqCEAkqJiEp8AhYWIQqChFJS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         "]]}]}, {}, {}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0ktLlFEAx+EzOlNqXsoUHMKFuwLFL6Cg9AU0EvdR0BDU1kC7aN5Ku6iI
aYtGrTEiIkpChpAQS7t4KZe2iL5AIuK259DiN89/9c6cd07dhWvnriZCCI/1
zIg762NM1fZ+YQhneDQZQjNPsZ2NvMSzvM5RddpZXuEib3Kd4/zFHPeY8uy8
neYmG/iHrTxkB4+lQshwUjn1aE4zuqFPBZ7Pz7zFNd7mOnv5hX28o692P79x
gN85yA0Oxd/AYd7Vln2P2xzhD47yJ+9zhw84pQU91LyeqFu1fvdlFvM8D5yn
hb9ZH7+bNUxqyf4b3zt3+Yhr7OE7ZviUI+qwu9jKi2xgG9Nsiu+Upznhuc9V
Zc9yWiftVVZyhSf4kce5zAp+YDnLlLdLuRT/B75nCRfjufiWRfFO6I19hK/p
yOFVPBtf0tUJL1gQ71fi//36B3bQTN8=
       "]]}, {
      Line3DBox[{1011, 1310, 1010, 740, 1012, 1482, 1700, 1013, 1483, 1701, 
       1014, 1484, 1702, 1015, 1485, 1703, 1016, 1311, 1017, 1588, 1312, 1018,
        1486, 1704, 1019, 1487, 1705, 1020, 1488, 1706, 1021, 1489, 1707, 
       1022, 1313, 1023, 1589, 1314, 1024, 1490, 1708, 1025, 1491, 1709, 1026,
        1492, 1710, 1027, 1493, 1711, 1028, 1315, 1029}], 
      Line3DBox[{1031, 1316, 1030, 1590, 1317, 1032, 756, 1033, 1494, 1712, 
       1034, 1495, 1713, 1035, 1496, 1714, 1036, 1318, 1037, 1591, 1319, 1038,
        1592, 1320, 1039, 1497, 1715, 1040, 1498, 1716, 1041, 1499, 1717, 
       1042, 1321, 1043, 1593, 1322, 1044, 1594, 1323, 1045, 1500, 1718, 1046,
        1501, 1719, 1047, 1502, 1720, 1048, 1324, 1049}], 
      Line3DBox[{1051, 1325, 1050, 1595, 1326, 1052, 1596, 1327, 1053, 1597, 
       1328, 1054, 1503, 1721, 1055, 1504, 1722, 1056, 1329, 1057, 1598, 1330,
        1058, 1599, 1331, 1059, 1600, 1332, 1060, 1505, 1723, 1061, 1506, 
       1724, 1062, 1333, 1063, 1601, 1334, 1064, 1602, 1335, 1065, 1603, 1336,
        1066, 1507, 1725, 1067, 1508, 1726, 1068, 1337, 1069}], 
      Line3DBox[{1071, 1338, 1070, 1604, 1339, 1072, 1605, 1340, 1073, 1606, 
       1341, 1074, 1607, 1342, 1075, 1509, 1727, 1076, 1343, 1077, 1608, 1344,
        1078, 1609, 1345, 1079, 1610, 1346, 1080, 1611, 1347, 1081, 1510, 
       1728, 1082, 1348, 1083, 1612, 1349, 1084, 1613, 1350, 1085, 1614, 1351,
        1086, 1615, 1352, 1087, 1511, 1729, 1088, 1353, 1089}], 
      Line3DBox[{1091, 1354, 1090, 1616, 1355, 1092, 1617, 1356, 1093, 1618, 
       1357, 1094, 1619, 1358, 1095, 1620, 1359, 1096, 1360, 1097, 1621, 1361,
        1098, 1622, 1362, 1099, 1623, 1363, 1100, 1624, 1364, 1101, 1625, 
       1365, 1102, 1366, 1103, 1626, 1367, 1104, 1627, 1368, 1105, 1628, 1369,
        1106, 1629, 1370, 1107, 1630, 1371, 1108, 1372, 1109}], 
      Line3DBox[{1111, 1373, 1110, 1512, 1730, 1112, 1513, 1731, 1113, 1514, 
       1732, 1114, 1515, 1733, 1115, 1516, 1734, 1116, 1374, 1117, 1631, 1375,
        1118, 1517, 1735, 1119, 1518, 1736, 1120, 1519, 1737, 1121, 1520, 
       1738, 1122, 1376, 1123, 1632, 1377, 1124, 1521, 1739, 1125, 1522, 1740,
        1126, 1523, 1741, 1127, 1524, 1742, 1128, 1378, 1129}], 
      Line3DBox[{1131, 1379, 1130, 1633, 1380, 1132, 1525, 1743, 1133, 1526, 
       1744, 1134, 1527, 1745, 1135, 1528, 1746, 1136, 1381, 1137, 1634, 1382,
        1138, 1635, 1383, 1139, 1529, 1747, 1140, 1530, 1748, 1141, 1531, 
       1749, 1142, 1384, 1143, 1636, 1385, 1144, 1637, 1386, 1145, 1532, 1750,
        1146, 1533, 1751, 1147, 1534, 1752, 1148, 1387, 1149}], 
      Line3DBox[{1151, 1388, 1150, 1638, 1389, 1152, 1639, 1390, 1153, 1535, 
       1753, 1154, 1536, 1754, 1155, 1537, 1755, 1156, 1391, 1157, 1640, 1392,
        1158, 1641, 1393, 1159, 1538, 1756, 1160, 1539, 1757, 1161, 1540, 
       1758, 1162, 1394, 1163, 1642, 1395, 1164, 1643, 1396, 1165, 1644, 1397,
        1166, 1541, 1759, 1167, 1542, 1760, 1168, 1398, 1169}], 
      Line3DBox[{1171, 1399, 1170, 1645, 1400, 1172, 1646, 1401, 1173, 1647, 
       1402, 1174, 1543, 1761, 1175, 1544, 1762, 1176, 1403, 1177, 1648, 1404,
        1178, 1649, 1405, 1179, 1650, 1406, 1180, 883, 1181, 1545, 1763, 1182,
        1407, 1183, 1651, 1408, 1184, 1652, 1409, 1185, 1653, 1410, 1186, 
       1654, 1411, 1187, 1546, 1764, 1188, 1412, 1189}], 
      Line3DBox[{1191, 1413, 1190, 1655, 1414, 1192, 1656, 1415, 1193, 1657, 
       1416, 1194, 1658, 1417, 1195, 1547, 1765, 1196, 1418, 1197, 1659, 1419,
        1198, 1660, 1420, 1199, 1661, 1421, 1200, 1662, 1422, 1201, 899, 1202,
        1423, 1203, 1663, 1424, 1204, 1664, 1425, 1205, 1665, 1426, 1206, 
       1666, 1427, 1207, 1667, 1428, 1208, 1429, 1209}], 
      Line3DBox[{1211, 1430, 1210, 1548, 1766, 1212, 1549, 1767, 1213, 1550, 
       1768, 1214, 1551, 1769, 1215, 1552, 1770, 1216, 1431, 1217, 1553, 1771,
        1218, 1554, 1772, 1219, 1555, 1773, 1220, 1556, 1774, 1221, 1557, 
       1775, 1222, 1432, 1223, 930, 1224, 1558, 1776, 1225, 1559, 1777, 1226, 
       1560, 1778, 1227, 1561, 1779, 1228, 1433, 1229}], 
      Line3DBox[{1231, 1434, 1230, 1668, 1435, 1232, 1562, 1780, 1233, 1563, 
       1781, 1234, 1564, 1782, 1235, 1565, 1783, 1236, 1436, 1237, 1669, 1437,
        1238, 1566, 1784, 1239, 1567, 1785, 1240, 1568, 1786, 1241, 1569, 
       1787, 1242, 1438, 1243, 1670, 1439, 1244, 946, 1245, 1570, 1788, 1246, 
       1571, 1789, 1247, 1572, 1790, 1248, 1440, 1249}], 
      Line3DBox[{1251, 1441, 1250, 1671, 1442, 1252, 1672, 1443, 1253, 1573, 
       1791, 1254, 1574, 1792, 1255, 1575, 1793, 1256, 1444, 1257, 1673, 1445,
        1258, 1674, 1446, 1259, 1576, 1794, 1260, 1577, 1795, 1261, 1578, 
       1796, 1262, 1447, 1263, 1675, 1448, 1264, 1676, 1449, 1265, 962, 1266, 
       1579, 1797, 1267, 1580, 1798, 1268, 1450, 1269}], 
      Line3DBox[{1271, 1451, 1270, 1677, 1452, 1272, 1678, 1453, 1273, 1679, 
       1454, 1274, 1581, 1799, 1275, 1582, 1800, 1276, 1455, 1277, 1680, 1456,
        1278, 1681, 1457, 1279, 1682, 1458, 1280, 1583, 1801, 1281, 1584, 
       1802, 1282, 1459, 1283, 1683, 1460, 1284, 1684, 1461, 1285, 1685, 1462,
        1286, 1686, 1463, 1287, 1585, 1803, 1288, 1464, 1289}], 
      Line3DBox[{1291, 1465, 1290, 1687, 1466, 1292, 1688, 1467, 1293, 1689, 
       1468, 1294, 1690, 1469, 1295, 1586, 1804, 1296, 1470, 1297, 1691, 1471,
        1298, 1692, 1472, 1299, 1693, 1473, 1300, 1694, 1474, 1301, 1587, 
       1805, 1302, 1475, 1303, 1695, 1476, 1304, 1696, 1477, 1305, 1697, 1478,
        1306, 1698, 1479, 1307, 1699, 1480, 1308, 1481, 1309}]}, {
      Line3DBox[{425, 725, 426, 740, 455, 755, 1590, 470, 770, 1595, 485, 785,
        1604, 500, 800, 1616, 515, 815, 530, 1730, 830, 545, 845, 1633, 560, 
       860, 1638, 575, 875, 1645, 590, 890, 1655, 605, 905, 620, 1766, 920, 
       635, 935, 1668, 650, 950, 1671, 665, 965, 1677, 680, 980, 1687, 695, 
       995, 710}], 
      Line3DBox[{427, 726, 428, 1700, 741, 456, 756, 471, 771, 1596, 486, 786,
        1605, 501, 801, 1617, 516, 816, 531, 1731, 831, 546, 1743, 846, 561, 
       861, 1639, 576, 876, 1646, 591, 891, 1656, 606, 906, 621, 1767, 921, 
       636, 1780, 936, 651, 951, 1672, 666, 966, 1678, 681, 981, 1688, 696, 
       996, 711}], 
      Line3DBox[{429, 727, 430, 1701, 742, 457, 1712, 757, 472, 772, 1597, 
       487, 787, 1606, 502, 802, 1618, 517, 817, 532, 1732, 832, 547, 1744, 
       847, 562, 1753, 862, 577, 877, 1647, 592, 892, 1657, 607, 907, 622, 
       1768, 922, 637, 1781, 937, 652, 1791, 952, 667, 967, 1679, 682, 982, 
       1689, 697, 997, 712}], 
      Line3DBox[{431, 728, 432, 1702, 743, 458, 1713, 758, 473, 1721, 773, 
       488, 788, 1607, 503, 803, 1619, 518, 818, 533, 1733, 833, 548, 1745, 
       848, 563, 1754, 863, 578, 1761, 878, 593, 893, 1658, 608, 908, 623, 
       1769, 923, 638, 1782, 938, 653, 1792, 953, 668, 1799, 968, 683, 983, 
       1690, 698, 998, 713}], 
      Line3DBox[{433, 729, 434, 1703, 744, 459, 1714, 759, 474, 1722, 774, 
       489, 1727, 789, 504, 804, 1620, 519, 819, 534, 1734, 834, 549, 1746, 
       849, 564, 1755, 864, 579, 1762, 879, 594, 1765, 894, 609, 909, 624, 
       1770, 924, 639, 1783, 939, 654, 1793, 954, 669, 1800, 969, 684, 1804, 
       984, 699, 999, 714}], 
      Line3DBox[{435, 730, 436, 745, 1588, 460, 760, 1591, 475, 775, 1598, 
       490, 790, 1608, 505, 805, 1621, 520, 820, 535, 835, 1631, 550, 850, 
       1634, 565, 865, 1640, 580, 880, 1648, 595, 895, 1659, 610, 910, 625, 
       1771, 925, 640, 940, 1669, 655, 955, 1673, 670, 970, 1680, 685, 985, 
       1691, 700, 1000, 715}], 
      Line3DBox[{437, 731, 438, 1704, 746, 461, 761, 1592, 476, 776, 1599, 
       491, 791, 1609, 506, 806, 1622, 521, 821, 536, 1735, 836, 551, 851, 
       1635, 566, 866, 1641, 581, 881, 1649, 596, 896, 1660, 611, 911, 626, 
       1772, 926, 641, 1784, 941, 656, 956, 1674, 671, 971, 1681, 686, 986, 
       1692, 701, 1001, 716}], 
      Line3DBox[{439, 732, 440, 1705, 747, 462, 1715, 762, 477, 777, 1600, 
       492, 792, 1610, 507, 807, 1623, 522, 822, 537, 1736, 837, 552, 1747, 
       852, 567, 1756, 867, 582, 882, 1650, 597, 897, 1661, 612, 912, 627, 
       1773, 927, 642, 1785, 942, 657, 1794, 957, 672, 972, 1682, 687, 987, 
       1693, 702, 1002, 717}], 
      Line3DBox[{441, 733, 442, 1706, 748, 463, 1716, 763, 478, 1723, 778, 
       493, 793, 1611, 508, 808, 1624, 523, 823, 538, 1737, 838, 553, 1748, 
       853, 568, 1757, 868, 583, 883, 598, 898, 1662, 613, 913, 628, 1774, 
       928, 643, 1786, 943, 658, 1795, 958, 673, 1801, 973, 688, 988, 1694, 
       703, 1003, 718}], 
      Line3DBox[{443, 734, 444, 1707, 749, 464, 1717, 764, 479, 1724, 779, 
       494, 1728, 794, 509, 809, 1625, 524, 824, 539, 1738, 839, 554, 1749, 
       854, 569, 1758, 869, 584, 1763, 884, 599, 899, 614, 914, 629, 1775, 
       929, 644, 1787, 944, 659, 1796, 959, 674, 1802, 974, 689, 1805, 989, 
       704, 1004, 719}], 
      Line3DBox[{445, 735, 446, 750, 1589, 465, 765, 1593, 480, 780, 1601, 
       495, 795, 1612, 510, 810, 1626, 525, 825, 540, 840, 1632, 555, 855, 
       1636, 570, 870, 1642, 585, 885, 1651, 600, 900, 1663, 615, 915, 630, 
       930, 645, 945, 1670, 660, 960, 1675, 675, 975, 1683, 690, 990, 1695, 
       705, 1005, 720}], 
      Line3DBox[{447, 736, 448, 1708, 751, 466, 766, 1594, 481, 781, 1602, 
       496, 796, 1613, 511, 811, 1627, 526, 826, 541, 1739, 841, 556, 856, 
       1637, 571, 871, 1643, 586, 886, 1652, 601, 901, 1664, 616, 916, 631, 
       1776, 931, 646, 946, 661, 961, 1676, 676, 976, 1684, 691, 991, 1696, 
       706, 1006, 721}], 
      Line3DBox[{449, 737, 450, 1709, 752, 467, 1718, 767, 482, 782, 1603, 
       497, 797, 1614, 512, 812, 1628, 527, 827, 542, 1740, 842, 557, 1750, 
       857, 572, 872, 1644, 587, 887, 1653, 602, 902, 1665, 617, 917, 632, 
       1777, 932, 647, 1788, 947, 662, 962, 677, 977, 1685, 692, 992, 1697, 
       707, 1007, 722}], 
      Line3DBox[{451, 738, 452, 1710, 753, 468, 1719, 768, 483, 1725, 783, 
       498, 798, 1615, 513, 813, 1629, 528, 828, 543, 1741, 843, 558, 1751, 
       858, 573, 1759, 873, 588, 888, 1654, 603, 903, 1666, 618, 918, 633, 
       1778, 933, 648, 1789, 948, 663, 1797, 963, 678, 978, 1686, 693, 993, 
       1698, 708, 1008, 723}], 
      Line3DBox[{453, 739, 454, 1711, 754, 469, 1720, 769, 484, 1726, 784, 
       499, 1729, 799, 514, 814, 1630, 529, 829, 544, 1742, 844, 559, 1752, 
       859, 574, 1760, 874, 589, 1764, 889, 604, 904, 1667, 619, 919, 634, 
       1779, 934, 649, 1790, 949, 664, 1798, 964, 679, 1803, 979, 694, 994, 
       1699, 709, 1009, 724}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJwsm3c0l+8fxkUqUdlKKZRCoUIp5W0mshMhCQ0jkj2yyd57772yt9veW4PM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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0.9, 0.95}, {1.8, 2}, {684.3915554225158, 684.3971138881079}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.6955544342617188`*^9, 3.6955554735722656`*^9, 
  3.6955556045097656`*^9, 3.6955558862753906`*^9, 3.6955560007753906`*^9, 
  3.695556362169922*^9, 3.695556474544922*^9, 3.6955566786591797`*^9, 
  3.6956162329003906`*^9, 3.6956205422978516`*^9, 3.6956223822041016`*^9, 
  3.6956277447314453`*^9, 3.6957341479960938`*^9, 3.695822065357422*^9, 
  3.6958228806523438`*^9, 3.6958718344942107`*^9, 3.695871970572336*^9, 
  3.695872429146555*^9, 3.695875067570383*^9, 3.695875202836008*^9, 
  3.695876187387766*^9, 3.6959784760742188`*^9, 3.696134944390625*^9, 
  3.696213244873047*^9, 3.697436059966797*^9, 3.697436210763672*^9, 
  3.697436314966797*^9},
 CellLabel->"Out[13]=",
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytff+PZNl11/O9972q6u75sl+89hrv1iZrJ56xZ+wZ2217Nu5KZpIeZyae
iafjGTLt7MtuJ9ted5KOXYk7ScO+QAgKMIFACBAS/EBECqAoAiKFACIFQpEQ
EkJCQkhITPEXICEkxE8pzudz7n3vvFdV413Evu2u16/el3s+55zP+XJv1Xz+
tZ/68o/++Gs/9ebBay/d/NprP/nlNw+mL+0ef00O+Xdl2bu+LD/F+Uz2/1Tm
/3s2XlSLN6tFlplXVy18lsnvTF4qOZC5LPNyPMv+ZDzFmzexX8T9DD/2yi/+
/7gg8Nk4K6TLHvw/3ff/ULLBO7rmfzcP91ce8RwdTsHfBpb/VS0CD+BEHMiO
8Pt/pvOyXG9bLeQ+Lr77PziiYfuM+Ogv481/3lwadHBZlptzvoXXbqQjcleL
xiEu+AOLWWE1avbHfMw5jBAD15OzN5euz/k8PgT/yTUv8MhTSeTefd9YuoMg
lw0t2vh5Px//7Du6SfOH48XPcxzvWXOLH307t3gPf7/P3MKC+SOtOlTvwbz5
tMFFfp7vDkNOpgz/lbtWf8/yCK6jvXTsm2P+L7yx4iNPrFTL1nxfx2n/mSe8
GA9PqlJuVWGfty36p/8n3vWleLiUU+3p9u6v4fT/yNO/1ZyOkSQB7ek/jNP/
AwfzgWju+l8tMj7hkn/PJ3wwHq7igIqq1qvhdSNzTYlr/l2DHTH/gLl4oM/i
8YI+yaf8EZ9i9fYt5qKhucg+7FVc+m/5MDvul3qXhqoU6UrjjfL6Q7j2X/Ox
H+6e7+RUrxdkm+aKL+GKP+TTLnWv8HJuwBX9h/CSf8mHXDaXjHqX2KfsR3+Q
vz9mLtnQS3K9ZGlsD3HV73NsV/l7q6pCb1RylOP5PcJ+NRo0bi634tk+nu1I
eq29c0z/ZMm1Lls7ypq75IodD22Z08nDv0vJto1kXu3bAqO6bkyfV4/6d/od
jufT5k7B3Gkr2nTVu43VDsPUP+SAPmNuU5jbbDTO196+f5v7uM1vczSv9C29
lUv3RTDeRrwOxrzZv81vcTSf7du+uWUEPI6obi63typW5QiaOHwnnvL3uDvp
WmRH/qTWWgZcmKcMeaXVRRMAE3WnNyBEVneZYMc8ctM8MkFby6McHifiYf8J
Ar7NAfwmB2yjxXeYMWyZMbhGL/G5dgzVjOO35myDRVgKH3z44XKK4Ol8L/ON
7zYjOdMfSUTDjkRG52QgqwDJ1wGiMY5af6PqpRuDlPLEwb1ErL7HjOpcawp0
yKKLy7rRhCeMpnljsjSmfElXL3D0N82IzieckONUlR1QbhR1xtp+NzNw2YpH
h/4f6WJNXj7Hy57p6ig3z7Y+Yo3kC2//SZrj3EqyinxPSyxiamGfNDBP2uDg
7q18xtq8+VledLvH3cC1CQd+SThHp+9p525r4zbffrabcTUSGcvG/ln7xJ6Q
sPoQPUBO7D3yl5a8bTem6OVSCDAPDkncvOtTxKHWZzHRTne9g4f9IqW5W6UM
q+w/xvKY7z7SOq+LeksPTQ+xlvp5PPAXKMsXzAND94GWq3MrFx6X6+Moy2CN
UfIxP9/Yjryclqel6LC047eBp+g/JkSp5KzVonwfnvEWRfkB8wx3WvYeY6Pt
oAufT/BlyF86Zi+DoRSnlOKL5gk5n0BNZL3bj6wU8eak+401QsBJsp+lEA/M
I4anZW4escoYGi1HnOwTrD3DObKvL4Xre3zmmdOSWdkK5xlFAWzMZJpSi6ZX
P+p78agpH2XD5/drfamPavxxFKn1nd7/q7zbvpIRwcrOn5YuSUGjrABGkbwb
KcbZNbf8HG75Exzyl5SvcEvctLlrq4MzabyMDC30drzWuxFVsh/jeF81yvWn
ZbN/hg9RDj5niULs5ixJ8SwHR9Hf5G5pbhW6t8pyTYsJgwxc72CtZDMOVWKY
1u0tvSWifa1r6t37Gz73CkhDoq5njDh3hq33KER/FNSWwa1MA/PMTd1n2dm6
tCJuOdU+e5REROpg0oez/TG8vkTyX9L9k/JEHntSWuk30j7Zsh3JBiHOk2WI
2kZNkjCT47OVloG8DEJ7IoHQd1Jasxielsm8wQStxw+Ny+Qt+lceFW2uBMGL
NYLzwT/UdCWSsGdOymbfcSiwG9pq1Qk7Nj/o7LPsqL0ZwmCN7DcwhIeU/dAM
4Wx3CM6gsW4glj+GCQxYQW6GMTLD2OrWChzJA47kTTOS8/JT6P4JqaDoPz/m
8Ll5/kbDXzMBon38xhoUruPZX+R4vsIRPH1C99KngsXWPDSYh26ah1rot9Y8
9Lvw0HuMbV9RAj2p8LBnEvby3GH3ua7naWfUzpAEJOc+Z5523jyNJcGLywWK
ZsgvLxX7b2hOKUOqdFgCCdV1UiYycqeSWi2NaUsNL+iYwDarxeeAXqgW3Rpl
Zemgnc0fV4Y4qTAG4nOOQxL7HHAwIWZgMSjIQKh7BH2y3swhx25vO2jicA+N
C0tDi93WXG2V52qtcqz3m5YyrOKk6vhwNCAOVazWEy5PitqKbhHHdh6ARXOB
1ny35s7XAfNtSwN9YinwXt75WJPnaTk04920boZX0W9I+vXo9dTFugGfswOw
4w7LqH3onY34OY71q5oMTEtukqrGgYtlZhuGqfxJS1PIPGkSJIYYFUEMhQ6d
bgo/Lap5YbzVrfGffgti7ZDfoU6eIUZfS2Y0LaGZjZMq8oFsAyNhaCQUFFS8
Xs6WuLiRCfMbrbaq+YYR1kZkmxX02wtPFvbFpZLwGbLa19RhVZykL3dSBbpt
jsjG46eVSuNMJPddafJWgiuPLLmOzH6+RnXvTJqdJSpU4hlMy00jR+juh64o
cYIgFZ9tjgBGanIxThK14x+uSRme6o6/hzXJ6hVa0U+r1dGKsqI7Xt8db9Eb
r89SgfnE4YYVQ7RD7w/3Ggb3GY7zpHHiyXSS0S4yP62iE7PvpPaekeSHZoCD
U1PI2Tyjl+Q4ZaiOH1vD6KcAZ2imaBCiQy1Hf0atQ8d4PCGIg5PKn9Su9UjE
wGrLDC9P+1q02YzMdxNBbwbo+8fj/mY3RWr2raGifZ19grBqueqOyyDjTRQS
pqUEo+KkZsQ+rTnMjdNKdjnSGiM+rZhWVstDbjJmUbcMN/Qhjvtn1igdPfrs
CgH9ObXI4xJbHkcI/Yv2czBB7Zoh1VLkMZXA/inNgIOzWbaLiSXtUYbmeoCa
IPqEsX20m3n+rB3kYGmQjoNE7nDKh3OoEl9qwc7r8Io2/+GwilWGmLWjwv4z
ZlSfwkguLTXcvm4HNpSBBR3YdKIjE0Osdfa3CyLY9VR8txppyXnl0cYazzhr
MXvWPHo7jkgzWnp+++ZUKfK4HPXGlEixlnHZMZ1LY0IyQciou3rLDgtcPBPr
21hhbjF59DoBxIHF8Hrl0c/oyIBR5o/LDVXgMRToOCpyH7O7rrmdsfoMAAyW
XyUvQK4TNJes6jNppKxvl711ZiqNvs19Mg3Zrjn4aQ2OHK87Htshh2nZUHUu
SMJrszjeNHbX3RcHdkS07QCcW6PydRHTZsafMNpvySdOGf9k9B7wo0Au1LN5
PPFJBKAvYkCGDP0nwd7KsGnG7bsyBELebXOtAPoJQXOwRgEU5yNWnKwjkQZ4
dySKmDRSiF5yI5SbTlJsXRJqwwiSGw6rtRGSdyJWVxPrcoF1wdVq6eMQa8Ok
AibRVGrzaULIp+UwPvZYouRf0XTiiGIfQU6hmUEUewyxM6oyBerCSD00Uhdp
H9kmVkXYLGK1svqF68C8t7FGkZR4tCqFy1uxOZdt/24oNevSa2GA0G5bfjQO
CQt55b5ofyyADI/H0eoZGvy0dFMJDRUR6aOg++A4umaDxWCNhkMPC4uZ7A+q
eY8FP7EWiEbQ3tKqrug2mRgYGLT/5Q/Hw6NxA4M4xuho7AmAU/9OhYrYBdiV
hJ8bJMJpZ1+R0CNLraJlOkrwND2EYAqY2ZZBw7rDlYRJbzLUolIsL14LPWvZ
MHC8rpcejg/H2eBwnEdQxvK6KT/gB2UHAhO6eEje4E9mEYZZpjmEghENpTPn
rX2rFoB+987aRyLGuUBxJsIx7+UUCQ7fk9c162dWthT6zrRp4Ch56dnDsTNA
bBwZkoz8Ga0jGDS8ooEcenY6Y1Yqtx0ZIFYlwauC1yBZBarZDD35OUUBGJ0c
5mORHzvy9FZJDI1xuN5+g88Zg8GXYvR7Q47Lz7nDFomRQcKvQGJaE4kB03J3
OhOi3Dqtm2S7n1o3eVnKPSCgU3mT8t0aX/gohr2ZjL1Xz/qUaDrz28fFO1HM
H9Tjr/OqNxYi5Zb8BOzJa+bUBsJXFpD8SKnxaNyILrmhCp8bwSNVnsQgsYkM
eoacr5sYn4vGDt3iyJaR1z9J3g+bA1ZlcS7v9YVIE7oSuTfaP7EfDikOkgHR
JQJiXyDRpMgjoiA9TLmuqDGcUmOnM2znjSrPqjgqHE27FSc34jxFxD/WF+Ss
EeQHou29urCyvB5l8UkWeXVQFuSANCKHR4ZW4u1pRY1U+bRGPozcXiq8EyaO
J9TTFjl7BlnAV7MzPd0U2jxTcUZGmsJIc976z5J2JIiJAXxBFwG+uiiMIJsq
SFBBDhlzGJVBsCrCMUQoRA8SVbIUdhLlbjZJ/QxzBbMN60nQxSCLbaSoj6GR
YLjGvC71BbCrbG/rquFGjAN4yIaKkcNZ8B9oIiYXYlMoVYLRh1NhoBk50vGV
E6ppcMoiU7PKKFk/meonT+l4SKIWRtKNNZJ+pC/p00bSzzX2l2XyM3p1kSfN
HQj90Z0cVSYZRE9cmt9xBe3hfmKBTC0rqz7Zz1fUB4gX+enMJkzrWoBNg0WD
ZDASbxqJbZyEsNlF6tAue/5ujZwPF424G424B+MDatiRCJsMYVliKPW48lGv
0HQOifkn4mI2TNLHyiElCyKurRR6iZHTbLlRrDdiClu6bhgslqc5lO+fi5I3
Z77byP9dmiY85LuvLlR+xIOg6j4YD43oFgZx1/wIvuooPTsYFXxW7rfB2qnt
bVszR4bQVuSnYgqzVZOofTyGqnL6su/pu0kLnk4r+xtZ+01haxodUJ4zoGhv
2D2cR1weLuR1s8EFqByMcxpGAQYGImDg/IgRRMlWCmY4AokMPaGpwSMYPArt
Vlg8ukKv8YUi2j9TwjMGkXXJQm9lo+9mC0uA2JX9r0RGuD9/KFtCJigyDxdi
Ms4whDsYKz0M++FJimSiwgqjOqeQaM3pDSRDU346jbmJIFZ1jRIbhpRNWDTW
pRJrl1Y+ERT7pg0On9Y86v7M3Z+Hh/Pc2E14uBg2+JBSBJ/Gi7oQidUcSV2O
qKEUCi7twIRJxS46zqAj+51uAxN75Y04o2ezLNJmpUXlM2uEXLHqdIlPQpoM
auD4RFxpck9GcH8GXDxxCQYXwWjwqmY3hIUGhqCqRZgjHLnCkSu30JEEkbMJ
EUh0ttvtYwMS6YBHUYDQwBuTOdp4GMVnKQCb6SHQ/4TTyhIKNMppGd9WnUVc
ahhx+Kj2Y+7V7h6VdH+maIiVFOJHXmAQMEC/gEKkp448SZeJpxCKFOcZiMUf
sT+MRhwkEkdqIAkKSYo2FpFMa1FNkAytICUtFAj1Gpvh5URnsVxqLa+5TSC4
pg9xob4gmY78+Auxa90tOS4Skyy/Vd/hdk9CoqJzr0Vn8HDeGErxcJG/uojm
AVvBa4gAibnE3gXOb9o5IYKF6BwSC8ursM5WCtMg5Z7tkGuaREO7VUWfWiPL
DHqA+QiYpV+d4/9Qx1CqxRJSQfZm2Hy3L/FBQuV2K3dLxqyAZe5O3eAlr3lr
TYLXXPFyxMuVYwsZqh4NTUjbDic9zNxRSZhSTmNQk/0R4zoqimmtwLH5k8U5
EnG5QQzMmcEAeIz6jBNdMf8m+M112a7rdrQ+2McyfqLlQoXNXajdBWJzYX6B
txkaOF+oFlIVhF0Ktlsppl4g9XdmxNJ3cQ335/4hs4uHjHtg9aBZouBbjiOP
H4y10JWEIBxOvEFVXBbusmSCQ5MpSpXZxL2t2DJoLVJw9d381kJra5rCQBt6
8K9smywhOXoCku7CfNBtpkt6kMMgduvdShAdNajWQDULYqszbOEeC7N7RLi4
P8vvg/fmwBR5hGTenqWGV2PVSagDsc9xoSYaCGZJKMVGe2iKaeY0TamqgoFy
02ac3QIj7xtkr67F/sA4us02ET9y3ed7FtAPrAJU3byGmwukwokzIJoN1DoF
21n2bgIrdw3XKdf1elfO362HEdIacMJQZ9bvHdEUE23tE64icIqFFmX0dHh/
YDo2iGiKl2f4kR2P2caOYYYUWLGhdcCZR/nZsJ2DHp6h78gr9mGF2h1R3N5O
s+dl4PkhE19d0wsHpGDPrpEWDahzAp1fml2aX1pc4rVXRfbtcrvCFq6JmDuV
luyjiHolr8VunSvqt+pkyLdmrSEn8D3B9wD/4VxvE8khEqxh3oBoDi6gETM/
OSo3u7jb0tEReWfsd9BtfRD+2LgJVMG8scdRF1cXkV6X/K1DvXhbs002hdYj
Z4zF+65ycqMcYRN5y10SlV1aXBaYrk6ultulj5rB4hxsVjND8QkvTMOERpzh
1sxDJXOrkpwqYZhCIBSFgF2uPCqUqvNUuR1MJMHED/SRqTsg+B1VZyyzWF8Y
dDXSq2eXs3B3Ou/HQEsbZw292Eahba2dY/AnqeTVihmgJ02Fha5mmv2kn5nq
J9LRzNARPGfuRTMBbnN1fHXiGsV4VUzmdgSs6yX1As4KqqPr1WC3psuo+yQt
SXid35NNKEvVFfclbXGS8IHCNE9MOZ+GU6GyqLim5HYHkxyudFjqPL8oDdGh
wnY2qQ4ulDIVYbDhtLalZejuc3mH6eiK3pokpvEWO/kAT7JFhG0l2inMb12r
t8Rmfmnmzn7K36/U2gyp4kqtOWrNXWIIF3eabJdhu/LWnbxRm7dqC7t1cauO
rCfqotZEacv68uwBgPSU51jn7o9L2bLcJETiYaKrkHR1WDIVOqqW1MUsXBhv
s6slx0QotgGSTxn/4rhO56epD3a2rWZURcOe861ium9JKnpbE4lLX6Fgfexs
TJ00ib9QN+pCSBLHvLDgJjBemodGR+WyjnLRUYg6Ut8C52HLjYYcNZSrhoJq
6B5wQMZ65ZEzxZN/ooZQBaC5KbopwxE1chSzKndcj44r60miIzOBkCHFsp0Z
znrON6mPpQbMipy/UUsvjXopqsW/wwnNJY3AWCXK9LRRJG1IYkBd5Epz0IZk
CJVTdVyjOgbJZbI12pjBX+7MCqoisOUxvz+/T4mjp1ANWejqwUc9TFQPVIJo
w+jhuD6WguC41n0Eb3GR6SxONZ+gOC1OZsUJ+6f4BMF8aDN9G1Vs1dVLeDtf
kdKbWX4pZgLveF51WRvnkn+Q3bpKQWIQLixULfmlhbs8Thx2tcyNQqCSIRQi
vFUmDksKCUYhQTKDO9CG5Aeoy0QP+f2FtiqzrioKVQUizIQhZZUWNo65wDIc
1/SDbEMcgZpAQnoyY0g5mTWhH1Ygf4CditN50Qv9G10FNIpp0aOb9Htwaf88
vYDUNXgb877mY8nt18ZE4DlQpgJ8DYz91IOoaBFUE169Q/Ln0pGuslz0EbWR
RXXsLKnD3ZL/Z6oRyQCcsJUMVQkr16WGVx5hHznAwrYFRTMD8hT8n/Hea/hA
1MhcIil5HSXnkNdY+lE/kj0X05lLqxDgKhuiKyzunSGM5JGwkD+PTue+z1Ur
ykG6VvymkrUf0D9rqYnO8+3m3aejC7DTMwDikgOrMhZ4vbQIEe6Jwi3Vittu
TP+a+EFZJLgZJUQVCW4xfoGb9biUKvM7Mto787iw8d4C27BBeX+8P86cokyI
1fqx9a1fIZeykA7gj2sLs+wPprB2IO1PxLbl5+xJgy8QZkPapFT5GnwHsRUb
IbZfwzHoGn+z/+IqgD3bF2ICsfBgxkTznl8gRSnSl8eAGj8CtQAur0tw+2tl
3oXbC+1nwNkxO0KgFaD9vQUwxuvg/iKGW6Cchf1xXlKlpXb9VyGdG6R1YqRQ
mIPCPK2HU2X8ucAbTuZxf0abhmgt87Rp7OB0Nc6hi7k3mNsP9OhXY9lc6YU+
2s8YtINBm+TOPNFATSK5rFAHQp1JSQGkM2H3/FoZGqQrBGh0lcjk4JCgrH6H
S9Rp2TToLCKOEm9/3Bi27KP4zgE6ttXAC534rok3ZZ/s58e1N4buyCf8cz4V
PBsdCC+kaCyv4gadUqJIWWqvUeeWdUDW6H/lkg2tVhXv76viWQ3RUIWoAKVA
Rx3C6+gtGWsPjKs4B4YOQg9SHWRkcH+dhJK53ZlX8JWrB8Lddxbu3qKlFAXf
dcF3yeLxql0QRlZP6EMDPQsBRNyh0ovBW7B3JBZJd9x0HgzeA4N3ULxT+im5
p2agg17AHSnGTQsDOA96ODe0/USgMdchzH3hLQWa2UyOfH/e0LgQzIuQdqeK
ZZZ4h+A52xULjnx8a45NMkZ/Z7GCPYKyx/5YTpXsBO0jZolAMF9lvOdiJRWh
4/5M7DXAZqdz4uYNb+QGQ9lPKTzSFVtYxdTFxwI4otjkd4Y58lVGm87ppONk
kW8zdv1cNN231HhRxfZM1yLb5ZMmUk4YLFt7DteqYod/ig4E/+tcw5ULiRB5
qOfWPCf+HXv2Ys8PxiAQ9qQDQ2SLf6AFS62EzimWwbGG1Q6RYM8WtBLFCtC9
AX2goIcIdLZ5Os+7OYhYsVhyTLkLA7VfA7VN/2yQfF8EXAb33ph/vNV0TQXc
jK8dnMHbheLMztzYLwEsFWu+U8PIATGMXLLsAMLgbQiyuzVHDq4Qe4U4k1TP
PxgLsNqjWzBM5utwRtKn86Er+zwogKZ1Pp3lJ6x7gDND4kYkYmCLn7OnGvj4
3/B0vmJtOMF13S95s58EPbcC0+bAe4wRV2z1K//GNnQPXLZoFFlii9xju4wR
MSHsiHK9I1sWdmpdi4ften19JkhL5jdvrDncWgy6OOcPxo4gx8j4cNHg7Ezh
GVIDAF0aNqc7SJ9J6zRamH2sPM8wk7Z0ceaUrIt9YA76WDLW1dmdy/qfSQ1r
vgg19JF/r04lx+lT7GASANQ8p3HPc8XbK97CFWNnEO/le7XfSas9BWbR4/WZ
35253bmDXd+SZ8uPgF3cWXgFe2/8QNB8gFKlMGFQkB42EwCTLGd9j9LysMQW
dKIVFQ1YZMMYNCddY5npEurobxFvr7acIPdm33XhHinc5NhRF+421q38JHD2
TT7H/K6+Dp5vEkGKsWKGi+W9j12vcTR7p+l2Syn88ABYRZAX/OVVoBdbl6vF
zheAv2PoD4h9NPH9CYEPK5TQabLA5A+5aSbSBFEpeAJ6XqVTJYS04CRnrY9k
44SsjsBwMt+MZU6y9k0mH8i6I6ufLlxPHU2ON+zpo0lMThdpwtue8sRPMi9p
431NLqhcJMeHXUXQH7JMSyD6g1FFXLLdcI8oRLyAneIZNtUIfAE8D6V46iQL
97RzDW+ASkQhYvj7E2SHQTWyPz5T2k4LyaenBq9qIOv4tAo4JuWqCE/+yUxw
ZUbeJDW9LGbY24fSUitrs58VFj3NtI2T0/aNTetC/XTnyYr6oDnwJ6LbvNUu
lknVKlgsqMLIYDoVg5Dc6AulEPnK7cyMgnZnEhdCVzuS5WhfcgGfgX5ELUU5
abL0rXJMvy1ZH5GtqBfXdQ9d1asJe7seS1svYWWJOkdzLObnc4Zjk1t2tQLT
P221Ym1/Vepj0/fC6MZ+6U7+TlXj+a2/DZeZdTlZpiWte5JiQF/bZSS0Gh7k
+uq5Phf1SOhe3FoooUlSykyzS2oOKdJkEFU0kddRqeQlf0BjmSsnhajKa0TJ
mgYZ7hj7lvCakSEy9BT8lENBdTCdBZORDo33WN1YnQm5SUrqsuVvhIxxJmJ6
Ch5rFIR9XnWup47Ocsu37zYvrNIQ0lhxmkANFdpU47Q/oznal9sC1irlZLlo
J+oGOVXmd1UxWOxyayEVr+90HEQ7hZLbvuilLHOjpAGVhCNBj1BJuegmxOYl
upf6CZqq0U/LcNpzmCq9DbSB6ds6TRttw27Mtx4FJ0oTiP08NkQdwVu81dMp
NXGaYo9VkVteBtBRxYuqxWa5UDMtWdBZBhfw2Q9H38gGUAFzrmxbS7SkAK8K
QLJVMMI33CX7eR/8vAVfvKF0Bn6rikhv5DPRQYEgw88hHFXtwosamDtTMI9S
eNHmQgO+wD5qIzvDfMRtOQgwbJwudL3F8LSLdNp3hrLs9xI+24d4bKw9NFMm
Zi2FTiPrB2T8Wqg1TnjOYYmh78rmdhc9rFEUs3Ps2OlpOxM92POybHD2JfOl
shRmQpctYY4YclDmiCEV17tUWxH2WmFvMN+cdnBu9r1i7rWCS5DnCiCMVbLf
RW9Beziloev7Fu/C7CuHjbje6rk+3i81eNfEO1e82TxuujyaIkkm9Tw6ZlIi
AEymRLfHLBFy7N9ZJDCzPFnwHsOvJKsItqX8BxsmmNhHAimMcsAjB6W8FsRQ
CodKW2XFUTVCXsTmMOcEgaUQ+ygRO6yXqVCcfxowLxXSsBD4rin2PhVaJJyB
pDJGB7wT/nmyOOGfLXtYQ+ay+Q+YA/Gb7NO6oGjIM10IhCU6wwu8lXYdNM3J
ctixWHG5zYJYDBmlcJ5yUWFsh+oghVMn8Hfzng53hy7yYrQeDbZy2AXcCVcc
MgO1/WEx46N6k7MgxXG9aYi6MGgXPZZQW1vh+dwHOwySQUewQ1dN3oCd9+xf
TFiMncuvG9r/Zgu2et9nrStNktG/pZV0oxuwipmgYly9OIaOMtemonR6oyK/
wzvszJTThXHIN7sLCad+vYZANVZDOjRXsh1R8r8to6iA/YPqULaMyethtTQ9
KPv+qB6IgyBnrYds0aneNKKui6WS9fienhor3+j7UVScp+5CT19WlfppLHzx
xaJZQ0s/eWcru/q5k2sc7ULVRAMs4TKqQxfk4rj1L6eNp5D8y3GSXWMyl6Jo
rXd97shtILTbY2zabBI+ywpht+hY99DTc/sTnzWxgXQGjVEbB5W8hgMG4EPo
BAkQ2//ymh/VwczjOrMvqsMS1DxlrBm5zUmxR1aziaqXIwbvDU1UV+nqVPtJ
EjxOCCR0dbIwTKZeF2IFo99y0Wrs6dUaS+7kl9d02W/Fs23aRmsaT1xcFzEP
RnHom1zkZJYqTsJ76CnOs3P1ZMVlGRzv1mIoistVZXuxeyJ6kyRqhd6C6u1A
E9boauGwDke19bDiKHJio7Uh9vkZAXz31yzNwZ/MpGJfVwOyk6U1YKu1rOtt
8KcCeZU64goFNlHqhC6j/ZqTx1n6aEpHhW9rzdfausTuv0y3lrD2Vlzozamr
JUXCA33suzjtvaT5CyxMJolCoTln5Nh+kY0k2ijU3aJk6oyyP+p1XvqpRcOd
rqw2DzDF5+CSB/WhbFlxWPuuNpNya3ld0mmzumIWs2RMx1GHOhW6gk2bkHey
aHTYUOmol6Gxx42/TpDsn7DyMIo9UcWmxzlOsDyWv6jgvK9g/w5Wj2mwsdnk
Sw1VhzixiikT9mZ40sWxaHPQ1WhInWXczvgmG/gZdBnQu59DiSEpcXCHn6LI
4Y/cJlkvS7GO6ctqFDm1PpAbH9TDJR1m+JvOd1TnRoe5LmLS7rIUaVTjnGrM
jRo3mskU5DAnCxvGXM8drfaiWgW01i2XFMj39KEnCzwdX0X6mNs8a5sJjZOm
Dyeu0GR/4Vnztm3ivcjvHyhSgkPv7CxKZ2cMSY38DJfVGVSdXACNWa9rtajT
oYEAdcI5tWF9PWY7XrWba45ze3xX7nSHoT8VVFoCyA/LKdCv6LtsdN04bCir
ouFeqFtqqnp0WDurbPGhbvRsSgNsgzQVmbFlzVmEObsI86JHmAyXnr+HbZp5
glIn0BFdYwjUq/zp4r3iDp4APa7wRPf2lqn11jy/nx44Wq86SXBE1OiDFxOr
hssTLhzElGWbmYJVBZ1rMyrNoylXo/Ew2J0hOcX8gk7uiPkopYqeRFdOEpsH
k3yfAbLRTV4ynYmsq4RqVJSBRbm44YyUDct1b7t/rGkNVnVO1Quj32Xnkkcq
shLqrO8NTIgc9d3ryiONiKodr+wLvfHPxtP1sPqfPFOe3/meLGruZWroeWoi
rUGv+prgzLxLagDvyIPfplaQuVyboQ3E5AWbeNEozfS0ivBUROCcgiqhzGLj
AU4yMKQY/STLzqee9TGDmTuehemsmOrnQ+IU/SaN184liDkzzMRsZKTtAmP7
SDs8QM4IcEuOtjCON1ysgnkpF3nZmP1zBPspG3i8zgoAak0HU/wJF8dcKyWM
NbmcFkKwz5kpvMJU4RrtfWeuKU/gFA7KZt/O0ztN6Qk24PbyKyAUYfOYwyld
Jw4xkydBWdQLou60ImMKIZFo00wcCFOFYzH1qAQ3nW8a4EMbeE7mGv43bLow
MDooVAe0aoQYaqIPutTW08dTgn78OPsmuD9D3N+tVLUWczG/ixNr68+Iue/M
C04UE9KZQBowXYz6CKCC+O/ShjPXwzXslyhNyypv6iQCKVk2/mTG7Q7bjEzI
Ptc2ZgIyT0AyO4N1jQyiedesmT5lMVnOjbVay7Udh+JEP3StjBJTskQikVN4
Pmhq+hhOJbr+bwzK9mO3T/XBPk+wn4/fGp4++5xlsR2UAJ4I3oOLbKdf1LpV
rDzHqnBsGBmi8rbEZDFyB0O/Nt+RDSqRqDxPUTmobna5NBwrfxbuLp9wF+be
sXanDANr5W8xfbAM/mm+rCirYAraAgnYIS37sMqNmraOmiDM/lx+PHNUVaMk
KCzo/nRuc2jsN5UL5sLWaMZ1tcRrSPqoQ+x5WcyTjbJAQRgLlfWYyho9SVln
qKw07/JWJPglRRVRUROoyn8TReVRUdmOjHFnHqS+aVzIqMmrmshKAUGAn5Ng
ilxSQfI6KiuE4DyVq6IVb9xp0PUfxy5qrQkSdCTKQfxNakEtaxRVdJU2MFHZ
qsZUovjQUk9nMVZETwH8+m2bco3qQh4L74nK2Ogr41uNMjapjPhvaF74hsZi
nXhZ6T7QCnJaxAcJwiGG34rxoUadeW3GbQ49MAovZJvn1+ehy2hhWR1iCV1d
bEhkMB7itOXDyEBCQ9E5oBJ8m7fOoAGrBQm3BnZPpQym88LQ+8hgPCAtWdSD
iQ6gK94lNkin1gNa0DefBPqIVcQHTQvbxSXmWVzr8s1RD4q6xGSBvUiwwwW8
+IC/vhC6ImlhFhLLRXfZ7iLuweDuGZ7d3iQA+gcN9PLDf0AU4UQVEDuoB5WG
ZozgkHW/pwakOsSU4/GsrwRiszklESlDwdpFC5rna82YYN844b87tewLjBlz
QA1Dz6aL6SLmXbx/NHgEi85X+CXsPbNROfqhyn7ee8YmGaKGZP8MwENAjZXl
YJzLEw+or1YEu3YN69TI/Wnd4J2FwO2uzzlxM7OJENLOO9wIOXIh8MXeOOxN
/APqdL/s4T0otUorq9TmjAZfJLxRDQyOZsUxRwCoj2exE010N5O1A4spa2LN
TkEbFtqRZXoWBispCF+6ZmD3MUdoAT/7JGPXJnX8EuW0Dtfsz2PJTEPPDfqB
Gigbzgf6+XatVr/NstkZJQjpw+45OZAtJ6RSNg8S9EGhfxChF+Q163dq6kBe
K4DY18pba8c0Tl0czQbJztkBmZ8hJlv8nSd6IDUQRcA2XfSJvMPwOc8S9aF7
GxW4iOSi1PUYF5x7ItRXHn1M6177aRVdrQ9gLwqMl0sA6y6XSO3zaNmAE+tx
CzVuQVWKJ+Fv9AmB6u4ioTrMuLrk7hib3zM8sjfODbIPErIg9cQgCVZJRAGl
pKUe+b0kocIhsGemovOtNpvBR+O60TNPZghHmqaerQIcLHMDTU2MrjwiSSxC
upVwtDt+7Lr/5vl5gya/M0S/csoaa/sJK6buQ9ZKpdZKl0tQhVdAEQvz1OGB
6caadGcOVr6u66cE0Lj+05EfXBfNYglNUAT+zTxJIqsepphhPNR2HGxUwS1Y
Mc0SF8M0j+cj2mjooZr2B0gdONVhDTe3pExceT1wTYlfC2tjjavBjQc+GWmY
eQaWHTh+7MGZbqi/OBGLRSmm2CYaRsQTY91EBUZ3X8A8ucgm6EQ5bDPrIepa
RBHkHjCChv2q6ALpOFUrHl8p13K/gyTXElLi47m8yr44vDdHBGTy8hybN+AO
E7gj/vZqvSsIuIUYVyohcFRyx8fYsu5XTp6PKbYkFduGZ3Xln7VYj2KTkovZ
ynYuo9tjyXKNGYK4uqxlUV7aLMtURIMiujceMIgxeIJKxUCluulBqj3HAjV8
a5i5wqkpptSdXThhUGkfYCU4mddmGt0ivTK75gz0tDNV6ltceV6I+OHGVx4d
M2MW3RhjfaYP5wfNgU/E7gmqSq7XTR8whp0GxdQrpkKuZVZIxKqwwV4lYRhs
s57Qdi8XwQJmZ1aHea42EJMNd0VLexIA5We4F8GdPGD8eyB8WuZdfD3xlaRs
oG0SncDWmbUjbro+LNpuF+xAgDePDd2KjebxDHCsmyaD7O5LMqDV+4DUEG2V
N8UDBgCZ2+MjGOtzfXS/rYduNx1w7wTfXKm2aPFVIy7SOgEArGsFpN7IDb7y
iofFVCyxQmvC7JMTVSGG3ODrEr6ZYhuO5f+eDcf9DYGYxmeA1XMWrqVYmnGv
UxLfE62ErOUUAOuOWrt9dx/Zb1+PLPfjt5itwvci8M3xo/gyko0kNdCPVmrG
hTCGpTLXdc2XfozhtrACZoSFeCcCcAOylgzCE1Jjuwdlk3S5ZMc2091gGGOa
y8lh8IVnZuCJb494FVnP+lre9czDcrJBMWXNpsgOLZTNDdg9nKOlp4Z65REN
9b19OD/0NuCMH08llJJolUDyYpm3hpplVyVsDbU+TlybLUOpc3iAsrgL1wfB
sjZDXcwsINNMQMDzTcaKaQSWDluaWwE/RilO7uRHDP7G37cIXKcaC4TQunBu
jXMwbS0zjz084BltvQl2eGNIbOXA0fzoMWrm9xkEkb3yux2vPPqkfgFs0OVw
WVzj2RQCzkJZXEZmVQLGzMmPR8IKNLfrFLuwTmjmUYO1OIrHu9twcX+XeRRt
U/ZRiw0kgE2wteQKYPcrSa/E/12TtbImC3GalOAyhMEyj2aCbTD4+oRvU5a2
KSfR75CknLPEq7191lndHHeZv92R7NF6JW9dQvvD5sDHkwFra6flA2YJbP0L
+ISjC7o3oHtrxmi/2cQWZhxujlUBzHJvTxpKCKqCuxNJJFCJJQUwf1D048Q5
zbtBf6BdIPRH+R+IIe+qwC/Rw7CrBbeGn6GUXBWRSorW7nPLI2LxSxrMMrFy
vtpFWO/p6+AjK3TwDa0rchvqBH0hpNwAHwzwaPR4BT4WFCMRWWC+LYAmAx9n
o7soceHeYAw17v1yY7/FUyzblbV20mxaNjiKNUIjZNHNwNi8iDltzMAGNNKh
rRbWoWTDloXruT5cl7pwxYVMPaxiSwz0kL0302YjLPC6VANOLNCQQGOERTRC
Fq+CHLv2sVxgLzImBo4WKagNFTWyglCtLzWbKus0RdV0IUG2hzN/NIvpFiVW
/8xbVmhh9bHG1frqeEFDzJLR0XD1RGu1UJmaW/ezEqtAvJxYlpnrN0CzHJrO
QLHBaOg2JDTF9ga0v2ql44Nt2Wj06/CW4EVrxBQVVisQaCQJeeoaoBhj2iVJ
gcCcM+GCvQJmMdCa+Jf18MD0GAXctmQQfz+ad7DRqEboFbnBcZqWTTVZ5IdB
6h+Qk7No4rRTXEoubSG2M9jv7kP8sX5uQJhj3bVoiq7cYGtJNb9a5WsgvZ4g
vRkhdawMYK95sl95Qz/sE6cDmXJhTpuQun0mBmTUrCjrgXF1wZIdc6A4pPiC
VnHERiHs9ojIFEs8QGY4XqS0ruiE/iNDhwZAO233bB/AKz0Ai2SpiEsufrlK
XEzj2A1YaaR9ICUa+esxDt0c3xznzPydpFQ9/DRA8a/MNT3xSSwJclIAgpGG
HUYiAlkQyJmYpPyW6LN5xDqKv/MjZb0syzLfhbDZF7hDFrMFvER6tFTJGz4J
u6vdZormUnOdYS6yPlzR7gAYm36dmMJQznm0iJxX5DKXsBtm2cZdU/nrdAEK
0oxNKUSWWhw3L+ucy8hmh9y0ITVjlBav3ThK+UoSdGD2BTnPPH64ZHma3xPa
Q5HxsGtjW2twQluaAYRtEWW/GbtN+QVWrRdL2D5aoRSBqbp/IjpZvkP3vDHG
3W6OPbMcySnBQPJ7j66OtCYaUax6mNvkBqlQ1v5A/p8BHzUWuuSoNaIIS+CR
YQJn0O00RT8kd6lbAiFEpVlrU+1HGc0y8Q5Kn1zR7fhGnAG0XCaWBVMKqa6R
/MRtV0Fx2u7NxmJmJEP/ONyIngjQwVtaJ95Fhbgp+XiDmnhbH699oIVsvEY7
/mAmiLkDZgOHTKBoWzFzIaMxZsyxsQaaK6LqbP4osl0n/2vAk3cPWYXIvQ/V
K7POv2PzdB+37Z4XCmhtUt0hLzW2Qo0tqLERvLwHXlpzgC8Wj/6XkjsxKobW
ck+2bLjHTp5meakLl+qX/dqVtbW2DLZGKQ9mxSGDlDqmp5tu4BB9a5YxQBzO
zycjRAQ56mTQXgk/4F0g7VUXtOTQ/YcbliD7VBeymAz/IV7dEmRcAVBy2JfL
5zKd219oZESEvDmmPWl+R3sKqO/KwR4QCQ8qwSLs195g4WIS1xpTA0ekrLP8
HQ5nhXHDIU2nOIp5RPRQER648bP7sJlDsnfWyRWe6iPwaVLSp1LAi4veMtfJ
Gcomu6XDXa7UZArMQhJsRDr1NqzGwobPL+lsDdk7Jz1J7sv6N9PaV4wn7EVr
kVvKjydIBUEKTLzcgbD4TKSS084c6uxoJCm1DL+EiwYs36UtJWtYj1xdGICW
2iwdeK51DUSbVXP9is1uztpi5LTfgsY2/KrmFMGMk7SZwuR6E1pZpqVqYAHV
1qYACFPilXvApPRBhU28amM/Jf8wJBCSpALOEPgWTAFOBrtaYROjZEFk+jl5
WlOILDQo43Sc3K/jOwi90kUopLz+YkxpUMQrKA1AoB/kAJc1mSEJXZUYtz3b
ngElGNT8Glc6+eupG4WZlZgEACOSkEaqhoTcXun2KthSUKz2q8E+p/W6DFQw
M2CruuN+Bbk8EDDNFjS+j4wpFcnXYAlALTJZ3vHbwzbUvW+NeWFhAP/V9nRg
O/6rMqkouohMpwBsF6vLshEvD4Ni/TNz1+YNUqGTru+yTGUplCsjadKIipMu
JyiFB4z/QEliG9dMdKlpSGoqtKwkPIHwCEg54RkdxlxAgxxOIaQzveCQxshU
MGZgOP3FNaZEND6buEgTyD/UUTcrEpWItRPHJOViKdAQFXU1sSQZt9oRV/1k
CF9hZ5HHZpBa0S5zUi3FCYpDNVN6oSKDyz6nNiFhF5ecuHhNLr26GF9xwqyU
+H+AMJYiv0T4w8TOc6QALnpbC6onvzdHWF3iwip+ZNd4WweuiTnwqZRTtqkX
WzgJLfG4ixXETjZ0lTaUBUXp2lwKvk3MAy8CmZol9KTBxjXY0LP4iP1qa5+F
zn6NTS7YEGhKSl7SKUI5KwwnKV+76DcRkYJHAEPJTfMpAMqrPHedwtN+inkd
JN9pDnw6po78gDMz7DFbC4oG7KqSSIZZR64IazimoOO4hMFtYiAUk4nj7FXY
hI0ZCGAk2M5QeskON5jeqLRiKLMiJYeiT6y+N3whp/mDjtIbz9G85QM92Tpy
fpc58JnkL4/JG5DTxeWKJTaVs03zAiISie7aXBmW3+BB6ihi/4QfhoSTME7f
hQkVjNJOY7XUWdB5JvSKjyns10X0ipn+zo1oAoI/oNoPhNKVKChmD4Jg4Tho
FW4nP7f6QFw3B64lH3jMb0NtlvI0VEHjvywhEzQhP4jKGcgCIfmaEAVCMp7L
5WqS2wUDx+2JfqXw7fKubGITZbFXNYmLmAQWQpBIA3+LOQhVoEgqIzcoT4A5
6fOuK6+jTfRA8AnTC0bOzT4IN8ib35HSk4Uu1IvpSaJK15V/dJW+C+m3Z1hH
X5jMTVI3pLbCBl67EowgtIZWfLEMegPyE8UB5xAHQKBOIOTJEgrG0nYslSfL
mKJAXEVFw0tQ/+dJjjaiUblhWF+21nFhjXVgP/uernUwxeXcBDASdgzJMhpY
BuIcV3l34CJFtyYksQyKq0jVV3LWRE7zNfDE7bIwqDhjHUxBKkna+M2tdall
pACxWSrbwTjgKvzTAMO/GwzoLaCXks7jut3pzb70u+bAK7G4eaycKjwobA8f
8FfpA/AFcYEhPkSxKFSshv5uT9ztMlfZUngR8hMSGNH/JVUIaaScrKI6y47C
chq8niDmkdi+27jc6Itw0xxAroTvJ400R892kckxa0w1XlS742qoq5FpyXRQ
nccCYC7MW7gb44I1m6ZGgSJiAh6xjgrbY2Yk5vygzinlZsy5xZZn+0mmEWUo
GjWmJ+b7rYnazuKoL+Hn6Ls7ibr+mNTFsj8F7ihmkk4M1V2u86S6q1SdxPI5
E0Emhex1oD5dSH0RboxRmd5s9elV4NsltgC1isSZOjLU+oAkxt8qvCaHojT0
w4zASezo7PLuJ54k6i1z4LP6PYhtSGYHjCqEiCIkPNJLnjITCa1LStaSszaA
iKrP/MbYUUS2dCbF7RLhGhUCHDHf40eD5fdeLbIxu6vl1SUJpdx0+6yQoFjq
MG8USl27/VmjXPAx/kxCE55PG9GGfblvmwPM2S78cUpsHWla1BsuVnygiD67
LA+8PAtXSXtd3bqdRWvFN8YDXHJzkti5oDrdXb0VhaevjiRl2auhUkW6aLXK
b1UXzcYcTq2WMjdRzHVrvEFfvO/riqf93hHaS5CBvUyjN696Y2J3Aw44vjkR
23Q3J4lyxChFi1BhuFuJkWztVQOO2XEsA/52Nq4kC2Vygt+ffdJ4P0+Pu87v
yHFxOqSK3sUwIP+9h96Tdweo9QKhxugcR+dpXcO9itNIwFmHIL99GqwMLSeU
ML+g5seTvnPNOEHlYrztgRtK34zmajAI5zLgIMaSwWQGNBc6irjJfFvMZXsO
i7kGZvFRmBuTVhhArWS1cbdSb7lLDnCUR/Y4TLwz5GiHjcNk0XlumCEW/fF/
vznw3ZHfoq/T9fmd3Jdn+VV1NRhJZ9Q7rGJ3Fn4yDjr2FHtg8zdhJpKNjO5W
ebJ2GbQMvMAnN9rx5mnUvhsR8/54v2AO7Oq/bEo7zi9HZGVogeOS0CnxAwOS
R98kpDc5GDFY7UdUQDMbiCfSPCRTzPkboGpxwPHAK0m+Ff9Z8vVju0eb/Vyy
2RQPxCJqMYKnMmp4AusYTMagwxvkFXEqHVhCLk9BTn6PyBPKFmGPBcJeDZ3L
GOOhFMEsc4f+2H7AHPhc1a7cQNMHo62Ly7zf1ZkQmb/G1btUqQBI9gF62Ia3
0QscQq+SY8IYMWJ5CXtVJC4ap+eQrXv4/pi+aA58r+4nCBzTPok2FbC7XMOD
yFExzuRX59u6yWXqPJMxV5rfSIFKxn2Tq/VuYsCKaXE3Dq0xgIyfJbtnRuL6
w7zfhc7K4zQgMhGoERAvc4DRxXWM2YZkJZMxiZTSUfHAEP59s2yIlq4igN4u
oxHYd0UBsaHyxTWQIi2TNDaaoPV4rbHirZQ/Gb9y9WgMM8u3UfxtiOJ3YL4y
2Fys8+aEORrc+KaOiuHb8/cPrgGNA7Fv2gR/xH//FN0yOoWn24ar84LPF1XK
A/PJmPnnjfGNCTYkrzfIhVRuQeXKGa/CCfW+/PJUBo6HXUKzfSxxyGfwbFqN
3OfaQvwQd5PnTfCU/IYun500JPb6qkfs9zm/nbjYwmTpXJ7gthcqD5bnvAJ5
3ES/4/SV8WQMc9A/w0StIjuE1+qNrjziY75kbm1bCS9AkipEZWaKiNCep2gg
VnWKZNzH6do0/h+ikdhb2g9b4msnL84kt9ngXeUGP83zeWlpLtox+//MPINO
88PdNLLZ/wPei6e8Zg5/R/dePp7yeqqZmzd/j185xp72j5jDnzH7/5jX8+PV
P2oO2+zvd9ovLnvDHLYTTf+Ap+CbpaGaOPuS3vwtvsl/SuBNc9gm1n+Xp/Af
SfqKOfxxs/+bPIX/Bu6ROWzn6X+dsqB8zn6Mo7Bv/hqv/wje/Alz+KNm/6/y
FFRvrRnI62Wz/8s8BUPPftIctkXrX+ApADD7Kkdh3/zzHCJ0lE3N4Ytm/8/y
emTV2U+Zw7Yr8BZPgTfB3JrDdjHtz/EUFJvZ1zkK++bX+SaS+OxnzGHblvoa
T0FEyn7WHLYtvGPKsodTfq7vHnH/iHdBTMhOzWH7SZVDngIiyv4UB2rfPOCb
oC7I3Bwem/2Sp4B6ssoctl35L3GgsN3s583h95v9H+RdYJ7Zn+Eo7Jtf5Js/
jjd/wRx+3ux/gad8Faf8OXPYTsR9nqdAX9kvmsN2NeP38hTgDUORUdg3dynF
n8abv2QO2xUZ13k9ZIQVNoftfPEOT8EYs79oDttp5Gs8Bc/I/hJHYd/c5puP
8OYvm8N24uPjHOiv4JS/bA7bzvZHeZdfxSl/xRy2TeEP85S/iVN+haOwb347
3/wNvPnXzGHbbHmZp9Q45VfNYVvCj3nK38cpf90cttWufqvNb+OUXzOHbWXz
Xt7lH+GUv8GB2jef5Zu/izf/ljlsM87zPOWf4pRfN4dttrLFU34fp/xtc9h1
5ZLdf4FTfoOjsG/mvP5f4c2/kw7jmwd4+N/g8DckD7/y6I+wm73r/wI4lkb7
\
\>"]]
}, Open  ]],

Cell[TextData[{
 StyleBox["\n\n\nReferences\n\n", "SmallText",
  FontSize->12],
 StyleBox["Leser, C. E. V. (1961): 'A Simple Method of Trend Construction.' \
Journal of the Royal Statistical Society Series B (Methodological) Vol. 23, \
pp. 91-107. \n(Online at \
http://links.jstor.org/sici?sici=0035-9246%281961%2923%3Al%3C91%3AASMOTC%3E2.\
0.CO%3B2-K)\n\nLudsteck, Johannes (2005) HPFilter, ", "Notebook",
  FontFamily->"Arial"],
 StyleBox["Mathematica", "Notebook",
  FontFamily->"Arial",
  FontSlant->"Italic"],
 StyleBox[" package, Wolfram Library Archive Mathsource\n(Online at ", 
  "Notebook",
  FontFamily->"Arial"],
 StyleBox["http://library.wolfram.com/infocenter/Demos/5161/",
  FontFamily->"Arial"],
 StyleBox[")\n\nSchlicht, Ekkehart and Pauly, Ralf (1983): 'Descriptive \
Seasonal Adjustment by Minimizing Perturbations.' Empirica No. 1, pp. 15-28.\n\
(Online at \
http://www.semverteilung.vwl.uni-muenchen.de/mitarbeiter/es/paper/pauly_und_\
schlicht_zerlegung-oekon-zeitreihen.pdf)\n\nSchlicht, Ekkehart (1984): \
'Seasonal Adjustment in a Stochastic Model.' Statistische Hefte Vol. 25, pp. \
1-12. \n(Online at \
http://www.semverteilung.vwl.uni-muenchen.de/mitarbeiter/es/paper/schlicht_\
seasonal-adjustment-in-a-stochastic-model.pdf)\n  \nSchlicht, Ekkehart \
(2005): \[OpenCurlyQuote] Estimating the Smoothing Parameter in the So-called \
Hodrick-Prescott Filter\[CloseCurlyQuote], ", "Notebook",
  FontFamily->"Arial"],
 StyleBox["Journal of the Japan Statistical Society", "Notebook",
  FontFamily->"Arial",
  FontSlant->"Italic"],
 StyleBox[", 35(1), 2005, pp. 99-119. \n(Online at ", "Notebook",
  FontFamily->"Arial"],
 StyleBox["http://www.scipress.org/journals/jjss/pdf/3501/35010099.pdf",
  FontFamily->"Arial"],
 StyleBox[")\n\nSchlicht, Ekkehart (2009):  \[OpenCurlyQuote]Trend Extraction \
from Time Series With Missing Observations and Structural Breaks, Journal of \
the Japan Statistical Society 2009, 38(2), 285-92.\n(Online at ", "Notebook",
  FontFamily->"Arial"],
 StyleBox["https://www.jstage.jst.go.jp/article/jjss/38/2/38_2_285/_pdf",
  FontFamily->"Arial"],
 StyleBox[")", "Notebook",
  FontFamily->"Arial"],
 StyleBox["\n", "SmallText"],
 "\n\n",
 StyleBox["Acknowledgement\n",
  FontSize->12],
 "\nI thank Johannes Ludsteck for helpimg me with expert advice in preparing \
this package. \n\n\nEkkehart Schlicht,\nDepartment of Economics\nUniversity \
of Munich,\nGermany\nwww.semverteilung.vwl.uni-muenchen.de/ekkehart\n\n\
October 2005\nrevised July 2006\nrevised February 2017\n"
}], "SmallTextSans",
 PageWidth->WindowWidth,
 CellMargins->{{Inherited, 0}, {Inherited, Inherited}},
 CellSize->{499, Inherited},
 CellChangeTimes->{{3.695628239100586*^9, 3.695628263663086*^9}, {
   3.695628298584961*^9, 3.695628398928711*^9}, {3.695628432303711*^9, 
   3.695628518631836*^9}, {3.695628559100586*^9, 3.695628602913086*^9}, {
   3.695628632944336*^9, 3.695628771413086*^9}, {3.6956288339941406`*^9, 
   3.6956289231816406`*^9}, 3.6956291221132812`*^9, {3.695629346584961*^9, 
   3.695629404084961*^9}, {3.695629441772461*^9, 3.695629451788086*^9}, {
   3.6956298540664062`*^9, 3.6956298631914062`*^9}, {3.695632265888672*^9, 
   3.695632274560547*^9}, 3.6956341647018986`*^9, {3.695635207603266*^9, 
   3.695635211353266*^9}, {3.695635253587641*^9, 3.695635269884516*^9}, {
   3.6956353384274845`*^9, 3.6956353781149845`*^9}, {3.6956354170993595`*^9, 
   3.6956354550681095`*^9}, {3.695875096195383*^9, 3.695875096632883*^9}, {
   3.6962130829765625`*^9, 3.6962131017734375`*^9}},
 TextJustification->1.,
 CellTags->"b:0"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{869, 494},
WindowMargins->{{-1, Automatic}, {Automatic, -7}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"], None, 
   Cell[
    TextData[{"The Season Package for ", 
      StyleBox["Mathematica", FontSlant -> "Italic"], 
      " by Ekkehart Schlicht"}], "PageHeader"]}, {
   Cell[
    TextData[{"The Season Package for ", 
      StyleBox["Mathematica", FontSlant -> "Italic"], 
      " by Ekkehart Schlicht"}], "PageHeader"], None, 
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"]}},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{595.1999999999999, 841.98},
"PrintCellBrackets"->True,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{50.375, 50.375}, {54, 36}}},
TaggingRules:>{
 "NextIndexingNumber" -> 2, "IndexEntries" -> {{"i:1", "HPFilter"}}},
ImageSize->{288, 288},
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (October 6, 2011)",
StyleDefinitions->"HelpBrowser.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:0"->{
  Cell[579, 22, 76, 1, 103, "Title",
   CellTags->"b:0"],
  Cell[658, 25, 361, 12, 55, "Text",
   CellTags->"b:0"],
  Cell[1022, 39, 2388, 60, 175, "Text",
   CellTags->"b:0"],
  Cell[3413, 101, 3033, 108, 188, "DefinitionBox",
   CellTags->{"i:1", "b:0"}],
  Cell[10053, 300, 63, 1, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[10119, 303, 316, 7, 27, "Input",
   CellTags->"b:0"],
  Cell[10438, 312, 170, 4, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[10611, 318, 2122, 39, 128, "Input",
   CellTags->"b:0"],
  Cell[12736, 359, 356, 9, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[13095, 370, 538, 15, 27, "Input",
   CellTags->"b:0"],
  Cell[13636, 387, 341, 16, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[28885, 752, 369, 11, 55, "MathCaption",
   CellTags->"b:0"],
  Cell[29257, 765, 531, 15, 27, "Input",
   CellTags->"b:0"],
  Cell[29791, 782, 563, 16, 71, "MathCaption",
   CellTags->"b:0"],
  Cell[49724, 1154, 1639, 58, 90, "DefinitionBox",
   CellTags->"b:0"],
  Cell[51366, 1214, 92, 2, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[53126, 1263, 516, 9, 90, "DefinitionBox",
   CellTags->"b:0"],
  Cell[53645, 1274, 92, 2, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[56358, 1343, 563, 22, 40, "DefinitionBox",
   CellTags->"b:0"],
  Cell[56924, 1367, 92, 2, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[57836, 1391, 1569, 59, 92, "DefinitionBox",
   CellTags->"b:0"],
  Cell[59408, 1452, 92, 2, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[194743, 3670, 3568, 69, 624, "SmallTextSans",
   CellTags->"b:0"]},
 "i:1"->{
  Cell[3413, 101, 3033, 108, 188, "DefinitionBox",
   CellTags->{"i:1", "b:0"}]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:0", 199553, 3781},
 {"i:1", 201102, 3828}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 76, 1, 103, "Title",
 CellTags->"b:0"],
Cell[658, 25, 361, 12, 55, "Text",
 CellTags->"b:0"],
Cell[1022, 39, 2388, 60, 175, "Text",
 CellTags->"b:0"],
Cell[3413, 101, 3033, 108, 188, "DefinitionBox",
 CellTags->{"i:1", "b:0"}],
Cell[6449, 211, 3601, 87, 207, "Text"],
Cell[10053, 300, 63, 1, 39, "MathCaption",
 CellTags->"b:0"],
Cell[10119, 303, 316, 7, 27, "Input",
 CellTags->"b:0"],
Cell[10438, 312, 170, 4, 39, "MathCaption",
 CellTags->"b:0"],
Cell[10611, 318, 2122, 39, 128, "Input",
 CellTags->"b:0"],
Cell[12736, 359, 356, 9, 39, "MathCaption",
 CellTags->"b:0"],
Cell[13095, 370, 538, 15, 27, "Input",
 CellTags->"b:0"],
Cell[13636, 387, 341, 16, 39, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[14002, 407, 639, 19, 27, "Input"],
Cell[14644, 428, 4871, 90, 232, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19552, 523, 86, 1, 37, "Subsection"],
Cell[CellGroupData[{
Cell[19663, 528, 91, 1, 33, "Subsubsection"],
Cell[19757, 531, 3320, 81, 55, "MathCaption"],
Cell[23080, 614, 86, 1, 23, "Text"],
Cell[CellGroupData[{
Cell[23191, 619, 2612, 67, 128, "Input"],
Cell[25806, 688, 3064, 61, 351, "Output"]
}, Open  ]],
Cell[28885, 752, 369, 11, 55, "MathCaption",
 CellTags->"b:0"],
Cell[29257, 765, 531, 15, 27, "Input",
 CellTags->"b:0"],
Cell[29791, 782, 563, 16, 71, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[30379, 802, 1432, 37, 90, "Input"],
Cell[31814, 841, 15354, 262, 232, 4693, 86, "CachedBoxData", "BoxData", \
"Output"],
Cell[47171, 1105, 1000, 17, 21, "Print"],
Cell[48174, 1124, 1535, 27, 21, "Print"]
}, Open  ]],
Cell[49724, 1154, 1639, 58, 90, "DefinitionBox",
 CellTags->"b:0"],
Cell[51366, 1214, 92, 2, 39, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[51483, 1220, 863, 24, 48, "Input"],
Cell[52349, 1246, 762, 14, 19, "Message"]
}, Open  ]],
Cell[53126, 1263, 516, 9, 90, "DefinitionBox",
 CellTags->"b:0"],
Cell[53645, 1274, 92, 2, 39, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[53762, 1280, 561, 17, 48, "Input"],
Cell[54326, 1299, 933, 17, 19, "Message"],
Cell[55262, 1318, 752, 15, 37, "Message"],
Cell[56017, 1335, 326, 5, 25, "Output"]
}, Open  ]],
Cell[56358, 1343, 563, 22, 40, "DefinitionBox",
 CellTags->"b:0"],
Cell[56924, 1367, 92, 2, 39, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[57041, 1373, 165, 4, 27, "Input"],
Cell[57209, 1379, 612, 9, 25, "Output"]
}, Open  ]],
Cell[57836, 1391, 1569, 59, 92, "DefinitionBox",
 CellTags->"b:0"],
Cell[59408, 1452, 92, 2, 39, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[59525, 1458, 637, 13, 27, "Input"],
Cell[60165, 1473, 134563, 2194, 272, 112827, 1836, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]],
Cell[194743, 3670, 3568, 69, 624, "SmallTextSans",
 CellTags->"b:0"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
